/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InterpolationAlgorithmType;
import com.supermap.analyst.spatialanalyst.InterpolationParameterNative;
import com.supermap.analyst.spatialanalyst.SearchMode;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Rectangle2D;

public abstract class InterpolationParameter
extends InternalHandleDisposable {
    private SearchMode a;

    protected InterpolationParameter(InterpolationAlgorithmType algorithmType) {
        this(algorithmType, 0.0, SearchMode.KDTREE_FIXED_COUNT, 0.0, 12);
    }

    protected InterpolationParameter(InterpolationAlgorithmType algorithmType, double resolution, SearchMode mode, double searchRadius, int expectedCount) {
        super.setHandle(InterpolationParameterNative.jni_New(InternalEnum.getUGCValue(algorithmType), resolution, InternalEnum.getUGCValue(mode), searchRadius, expectedCount), true);
        this.a = mode;
        this.setBounds(Rectangle2D.getEMPTY());
    }

    protected InterpolationParameter(InterpolationAlgorithmType algorithmType, double resolution) {
        this(algorithmType, resolution, SearchMode.KDTREE_FIXED_COUNT, 0.0, 12);
    }

    public double getResolution() {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getResolution()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationParameterNative.jni_GetResolution(this.getHandle());
    }

    public void setResolution(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("setResolution(double value)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResourceSpatialanalyst.loadString("value", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameterNative.jni_SetResolution(this.getHandle(), value);
    }

    public SearchMode getSearchMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getSearchMode()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this.a;
    }

    public void setSearchMode(SearchMode searchMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("setSearchMode(SearchMode searchMode)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(searchMode);
        InterpolationParameterNative.jni_SetSearchMode(this.getHandle(), n);
        this.a = searchMode;
    }

    public double getSearchRadius() {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getSearchRadius()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationParameterNative.jni_GetSearchRadius(this.getHandle());
    }

    public void setSearchRadius(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("setSearchRadius(double value)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResourceSpatialanalyst.loadString("value", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameterNative.jni_SetSearchRadius(this.getHandle(), value);
    }

    public int getExpectedCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getExpectedCount()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationParameterNative.jni_GetExpectedCount(this.getHandle());
    }

    public void setExpectedCount(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("setExpectedCount(int value)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0) {
            String string = InternalResourceSpatialanalyst.loadString("value", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameterNative.jni_SetExpectedCount(this.getHandle(), value);
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getBounds()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        InterpolationParameterNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setBounds(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("setBounds(Rectangle2D rectangle2D)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (rectangle2D == null) {
            rectangle2D = Rectangle2D.getEMPTY();
        }
        double[] dArray = new double[]{rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop()};
        InterpolationParameterNative.jni_SetBounds(this.getHandle(), dArray);
    }

    public int getMaxPointCountForInterpolation() {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getMaxPointCountForInterpolation()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.a != SearchMode.QUADTREE) {
            String string = InternalResourceSpatialanalyst.loadString("getMaxPointCountForInterpolation()", "InterpolationAlgorithmType_NotMatch", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationParameterNative.jni_GetMaxPointCountForInterpolation(this.getHandle());
    }

    public void setMaxPointCountForInterpolation(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("setMaxPointCountForInterpolation(int value)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.a != SearchMode.QUADTREE) {
            String string = InternalResourceSpatialanalyst.loadString("setMaxPointCountForInterpolation()", "InterpolationAlgorithmType_NotMatch", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameterNative.jni_SetMaxPointCountForInterpolation(this.getHandle(), value);
    }

    public int getMaxPointCountInNode() {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getMaxPointCountInNode()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.a != SearchMode.QUADTREE) {
            String string = InternalResourceSpatialanalyst.loadString("getMaxPointCountInNode()", "InterpolationAlgorithmType_NotMatch", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationParameterNative.jni_GetMaxPointCountInNode(this.getHandle());
    }

    public void setMaxPointCountInNode(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("setMaxPointCountInNode(int value)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.a != SearchMode.QUADTREE) {
            String string = InternalResourceSpatialanalyst.loadString("setMaxPointCountInNode()", "InterpolationAlgorithmType_NotMatch", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameterNative.jni_SetMaxPointCountInNode(this.getHandle(), value);
    }

    public abstract InterpolationAlgorithmType getType();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Bounds={");
        stringBuffer.append(this.getBounds().toString());
        stringBuffer.append("},ExpectedCount=");
        stringBuffer.append(this.getExpectedCount());
        stringBuffer.append(",Resolution=");
        stringBuffer.append(this.getResolution());
        stringBuffer.append(",SearchMode=");
        stringBuffer.append(this.getSearchMode().name());
        stringBuffer.append(",SearchRadius=");
        stringBuffer.append(this.getSearchRadius());
        stringBuffer.append(",Type=");
        stringBuffer.append(this.getType().name());
        if (this.getSearchMode() == SearchMode.QUADTREE) {
            stringBuffer.append(",MaxPointCountForInterpolation=");
            stringBuffer.append(this.getMaxPointCountForInterpolation());
            stringBuffer.append(",MaxPointCountInNode=");
            stringBuffer.append(this.getMaxPointCountInNode());
        }
        return stringBuffer.toString();
    }

    public void dispose() {
        if (super.getHandle() != 0L) {
            InterpolationParameterNative.jni_Dispose(this.getHandle());
            this.setHandle(0L);
        }
    }
}

