/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.GridAnalystSetting;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasetVector;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalGeometrySpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalHandleSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.ViewShedType;
import com.supermap.analyst.spatialanalyst.VisibilityAnalystNative;
import com.supermap.analyst.spatialanalyst.VisibleResult;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.GeoLine;
import com.supermap.data.InternalHandle;
import com.supermap.data.Point3D;
import com.supermap.data.Point3Ds;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedHelper;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

public class VisibilityAnalyst {
    private static transient Vector a;
    private static License b;
    private static GridAnalystSetting c;

    private VisibilityAnalyst() {
        c = null;
    }

    public static GridAnalystSetting getAnalystSetting() {
        return c;
    }

    public static void setAnalystSetting(GridAnalystSetting gridAnalystSetting) {
        if (gridAnalystSetting == null) {
            c = null;
            return;
        }
        if (c == null) {
            c = new GridAnalystSetting();
        }
        c.setBounds(gridAnalystSetting.getBounds());
        c.setBoundsType(gridAnalystSetting.getBoundsType());
        c.setCellSizeType(gridAnalystSetting.getCellSizeType());
        c.setCellSize(gridAnalystSetting.getCellSize());
        c.setOutputDatasource(gridAnalystSetting.getOutputDatasource());
        c.setGridOutputNamePrefix(gridAnalystSetting.getGridOutputNamePrefix());
        c.setVectorOutputNamePrefix(gridAnalystSetting.getVectorOutputNamePrefix());
        c.setValidRegion(gridAnalystSetting.getValidRegion());
        c.setShowProgress(gridAnalystSetting.isShowProgress());
    }

    public static VisibleResult isVisible(DatasetGrid sourceDataset, Point3D fromPoint, Point3D toPoint) {
        VisibilityAnalyst.a();
        if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        dArray[0] = fromPoint.getX();
        dArray[1] = fromPoint.getY();
        dArray[2] = fromPoint.getZ();
        dArray2[0] = toPoint.getX();
        dArray2[1] = toPoint.getY();
        dArray2[2] = toPoint.getZ();
        boolean[] blArray = new boolean[1];
        int[] nArray = new int[2];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[1];
        VisibilityAnalystNative.jni_IsVisible(l, dArray, dArray2, blArray, nArray, dArray3, dArray4);
        Point3D point3D = new Point3D();
        point3D.setX(dArray3[0]);
        point3D.setY(dArray3[1]);
        point3D.setZ(dArray3[2]);
        VisibleResult visibleResult = new VisibleResult(blArray[0], nArray[0], nArray[1], point3D, dArray4[0]);
        return visibleResult;
    }

    private static DatasetVector a(DatasetGrid datasetGrid, Point3D point3D, Point3D point3D2, Datasource datasource, String string) {
        VisibilityAnalyst.a();
        if (datasetGrid == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)datasetGrid) == 0L) {
            String string2 = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (datasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource) == 0L) {
            datasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : datasetGrid.getDatasource();
        }
        if (InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource) == 0L) {
            String string3 = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        if (null == string) {
            String string4 = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (null != c && null != c.getVectorOutputNamePrefix()) {
            string = c.getVectorOutputNamePrefix() + string;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasetGrid);
        long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource);
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        dArray[0] = point3D.getX();
        dArray[1] = point3D.getY();
        dArray[2] = point3D.getZ();
        dArray2[0] = point3D2.getX();
        dArray2[1] = point3D2.getY();
        dArray2[2] = point3D2.getZ();
        long l3 = VisibilityAnalystNative.jni_LineOfSight(l, dArray, dArray2, l2, string);
        DatasetVector datasetVector = null;
        if (l3 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l3, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static GeoLine[] lineOfSight(DatasetGrid sourceDataset, Point3D fromPoint, Point3D toPoint) {
        VisibilityAnalyst.a();
        if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        dArray[0] = fromPoint.getX();
        dArray[1] = fromPoint.getY();
        dArray[2] = fromPoint.getZ();
        dArray2[0] = toPoint.getX();
        dArray2[1] = toPoint.getY();
        dArray2[2] = toPoint.getZ();
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
        long[] lArray = VisibilityAnalystNative.jni_LineOfSightGeoLine(l, dArray, dArray2);
        int n = lArray.length;
        GeoLine[] geoLineArray = new GeoLine[n];
        for (int i = 0; i < n; ++i) {
            geoLineArray[i] = (GeoLine)InternalGeometrySpatialanalyst.createInstance(lArray[i]);
        }
        return geoLineArray;
    }

    public static VisibleResult[] isVisible(DatasetGrid sourceDataset, Point3Ds fromPoints, Point3Ds toPoints) {
        int n;
        VisibilityAnalyst.a();
        if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
        double[] dArray = new double[fromPoints.getCount() * 3];
        double[] dArray2 = new double[toPoints.getCount() * 3];
        for (n = 0; n < fromPoints.getCount(); ++n) {
            dArray[3 * n] = fromPoints.getItem(n).getX();
            dArray[3 * n + 1] = fromPoints.getItem(n).getY();
            dArray[3 * n + 2] = fromPoints.getItem(n).getZ();
        }
        for (n = 0; n < toPoints.getCount(); ++n) {
            dArray2[3 * n] = toPoints.getItem(n).getX();
            dArray2[3 * n + 1] = toPoints.getItem(n).getY();
            dArray2[3 * n + 2] = toPoints.getItem(n).getZ();
        }
        n = fromPoints.getCount() * toPoints.getCount();
        boolean[] blArray = new boolean[n];
        int[] nArray = new int[n * 2];
        double[] dArray3 = new double[n * 3];
        double[] dArray4 = new double[n];
        VisibilityAnalystNative.jni_IsVisible(l, dArray, dArray2, blArray, nArray, dArray3, dArray4);
        VisibleResult[] visibleResultArray = new VisibleResult[n];
        for (int i = 0; i < n; ++i) {
            Point3D point3D = new Point3D();
            point3D.setX(dArray3[3 * i]);
            point3D.setY(dArray3[3 * i + 1]);
            point3D.setZ(dArray3[3 * i + 2]);
            visibleResultArray[i] = new VisibleResult(blArray[i], nArray[2 * i], nArray[2 * i + 1], point3D, dArray4[i]);
        }
        return visibleResultArray;
    }

    public static DatasetGrid calculateViewShed(DatasetGrid sourceDataset, Point3D viewPoint, double startAngle, double viewAngle, double viewRadius, Datasource targetDatasource, String targetDatasetName) {
        return VisibilityAnalyst.calculateViewShed(sourceDataset, viewPoint, startAngle, viewAngle, viewRadius, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid calculateViewShed(DatasetGrid sourceDataset, Point3D viewPoint, double startAngle, double viewAngle, double viewRadius, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            VisibilityAnalyst.a();
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : sourceDataset.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            boolean bl = false;
            if (null != c) {
                bl = c.isShowProgress();
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            double[] dArray = new double[]{viewPoint.getX(), viewPoint.getY(), viewPoint.getZ()};
            long l3 = VisibilityAnalystNative.jni_CalculateViewShed(l, dArray, startAngle, viewAngle, viewRadius, l2, targetDatasetName, bl);
            DatasetGrid datasetGrid = null;
            if (l3 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l3, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetGrid calculateViewShed(DatasetGrid sourceDataset, Point3Ds viewPoints, double[] startAngles, double[] viewAngles, double[] viewRadiuses, Datasource targetDatasource, String targetDatasetName, ViewShedType viewShedType) {
        return VisibilityAnalyst.calculateViewShed(sourceDataset, viewPoints, startAngles, viewAngles, viewRadiuses, targetDatasource, targetDatasetName, viewShedType, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid calculateViewShed(DatasetGrid sourceDataset, Point3Ds viewPoints, double[] startAngles, double[] viewAngles, double[] viewRadiuses, Datasource targetDatasource, String targetDatasetName, ViewShedType viewShedType, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            VisibilityAnalyst.a();
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : sourceDataset.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            boolean bl = true;
            if (null != c) {
                bl = c.isShowProgress();
            }
            if (listeners == null || listeners.length == 0) {
                bl = false;
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            double[] dArray = new double[viewPoints.getCount() * 3];
            for (int i = 0; i < viewPoints.getCount(); ++i) {
                dArray[3 * i] = viewPoints.getItem(i).getX();
                dArray[3 * i + 1] = viewPoints.getItem(i).getY();
                dArray[3 * i + 2] = viewPoints.getItem(i).getZ();
            }
            long l3 = VisibilityAnalystNative.jni_CalculateViewShed2(l, dArray, startAngles, viewAngles, viewRadiuses, l2, targetDatasetName, viewShedType.value(), bl);
            DatasetGrid datasetGrid = null;
            if (l3 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l3, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (a == null) {
            a = new Vector();
        }
        if (!a.contains(l)) {
            a.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (a != null && a.contains(l)) {
            a.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (a != null) {
            Vector vector = a;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "VisibilityAnalyst";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        SteppedHelper.fire((Collection)a, (SteppedEvent)steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a() {
        int n = -1;
        Object object = b;
        synchronized (object) {
            n = b.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static DatasetVector radarShieldAngle(DatasetGrid sourceDataset, Point3D viewPoint, double startAngle, double viewAngle, double viewRadius, Datasource targetDatasource, String targetDatasetName, double interval) {
        return VisibilityAnalyst.radarShieldAngle(sourceDataset, viewPoint, startAngle, viewAngle, viewRadius, targetDatasource, targetDatasetName, interval, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetVector radarShieldAngle(DatasetGrid sourceDataset, Point3D viewPoint, double startAngle, double viewAngle, double viewRadius, Datasource targetDatasource, String targetDatasetName, double interval, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            VisibilityAnalyst.a();
            if (viewPoint.getZ() <= 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("viewPoint", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (interval <= 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("interval", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : sourceDataset.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            double[] dArray = new double[]{viewPoint.getX(), viewPoint.getY(), viewPoint.getZ()};
            long l3 = VisibilityAnalystNative.jni_RadarShieldAngle(l, dArray, startAngle, viewAngle, viewRadius, l2, targetDatasetName, interval);
            DatasetVector datasetVector = null;
            if (l3 != 0L) {
                datasetVector = InternalDatasetVector.createInstance(l3, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
            }
            DatasetVector datasetVector2 = datasetVector;
            return datasetVector2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetVector radarShieldAngle(DatasetGrid[] sourceDatasets, Point3D viewPoint, double startAngle, double viewAngle, double viewRadius, Datasource targetDatasource, String targetDatasetName, double interval) {
        return VisibilityAnalyst.radarShieldAngle(sourceDatasets, viewPoint, startAngle, viewAngle, viewRadius, targetDatasource, targetDatasetName, interval, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetVector radarShieldAngle(DatasetGrid[] sourceDatasets, Point3D viewPoint, double startAngle, double viewAngle, double viewRadius, Datasource targetDatasource, String targetDatasetName, double interval, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            VisibilityAnalyst.a();
            if (viewPoint.getZ() <= 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("viewPoint", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (interval <= 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("interval", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (sourceDatasets == null) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDatasets", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (sourceDatasets.length < 2) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDatasets", "DatasetsCountLessThanTwo", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long[] lArray = new long[sourceDatasets.length];
            for (int i = 0; i < sourceDatasets.length; ++i) {
                if (sourceDatasets[i] == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasets[i]) == 0L) {
                    String string = InternalResourceSpatialanalyst.loadString("sourceDatasets", "Global_ArgumentNull", "spatialanalyst_resources");
                    throw new NullPointerException(string);
                }
                lArray[i] = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasets[i]);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            double[] dArray = new double[]{viewPoint.getX(), viewPoint.getY(), viewPoint.getZ()};
            long l2 = VisibilityAnalystNative.jni_RadarShieldAngleArr(lArray, dArray, startAngle, viewAngle, viewRadius, l, targetDatasetName, interval);
            DatasetVector datasetVector = null;
            if (l2 != 0L) {
                datasetVector = InternalDatasetVector.createInstance(l2, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
            }
            DatasetVector datasetVector2 = datasetVector;
            return datasetVector2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        b = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

