/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.FieldMapping;
import com.supermap.analyst.spatialanalyst.InternalDatasetVector;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalHandleSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.MergeValueRule;
import com.supermap.analyst.spatialanalyst.SpatialJoinNative;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.InternalHandle;
import com.supermap.data.SpatialQueryMode;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.HashSet;
import java.util.Vector;

public class SpatialJoin {
    private transient Vector a;
    protected long m_selfEventHandle;

    public DatasetVector execute(DatasetVector sourceDataset, DatasetVector targetDataset, SpatialQueryMode spatialRelationMode, FieldMapping[] fieldMappings, boolean isSaveAllTargetFeature, double tolerance, Datasource outputDatasource, String outputDatasetName) {
        this.a(sourceDataset, targetDataset, fieldMappings, spatialRelationMode, tolerance, outputDatasource, outputDatasetName);
        long l = SpatialJoinNative.jni_NewHandle();
        if (l == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("SpatialJoin", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
        long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDataset);
        long l4 = InternalHandleSpatialanalyst.getHandle((InternalHandle)outputDatasource);
        int n = spatialRelationMode.value();
        String[] stringArray = new String[fieldMappings.length];
        int[] nArray = new int[fieldMappings.length];
        String[] stringArray2 = new String[fieldMappings.length];
        for (int i = 0; i < fieldMappings.length; ++i) {
            stringArray[i] = fieldMappings[i].getSourceField();
            nArray[i] = fieldMappings[i].getMergeValueRule().value();
            stringArray2[i] = fieldMappings[i].getOutputField();
        }
        this.m_selfEventHandle = SpatialJoinNative.jni_NewSelfEventHandle(this);
        long l5 = SpatialJoinNative.jni_SpatialJoin(this.m_selfEventHandle, l, l2, l3, n, stringArray, nArray, stringArray2, isSaveAllTargetFeature, tolerance, l4, outputDatasetName);
        if (this.m_selfEventHandle != 0L) {
            SpatialJoinNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
        }
        if (l5 != 0L) {
            DatasetVector datasetVector = InternalDatasetVector.createInstance(l5, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
            SpatialJoinNative.jni_DeleteHandle(l);
            return datasetVector;
        }
        if (SpatialJoinNative.jni_GetExecuteState(l) == -1) {
            SpatialJoinNative.jni_DeleteHandle(l);
            return null;
        }
        String string = SpatialJoinNative.jni_GetErrorMessage(l);
        SpatialJoinNative.jni_DeleteHandle(l);
        throw new RuntimeException(string);
    }

    private void a(DatasetVector datasetVector, DatasetVector datasetVector2, FieldMapping[] fieldMappingArray, SpatialQueryMode spatialQueryMode, double d, Datasource datasource, String string) {
        if (datasetVector == null) {
            String string2 = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (datasetVector2 == null) {
            String string3 = InternalResourceSpatialanalyst.loadString("targetDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (fieldMappingArray == null) {
            String string4 = InternalResourceSpatialanalyst.loadString("fieldMappings", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (fieldMappingArray.length == 0) {
            String string5 = InternalResourceSpatialanalyst.loadString("fieldMappings", "Global_ArrayLengthShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (spatialQueryMode == SpatialQueryMode.DISJOINT || spatialQueryMode == SpatialQueryMode.NONE) {
            String string6 = InternalResourceSpatialanalyst.loadString("spatialQueryMode", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        if (d <= 0.0) {
            String string7 = InternalResourceSpatialanalyst.loadString("tolerance", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        if (datasource == null) {
            String string8 = InternalResourceSpatialanalyst.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string8);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string9 = InternalResourceSpatialanalyst.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string9);
        }
        HashSet<DatasetType> hashSet = new HashSet<DatasetType>();
        hashSet.add(DatasetType.POINT);
        hashSet.add(DatasetType.LINE);
        hashSet.add(DatasetType.REGION);
        hashSet.add(DatasetType.LINEM);
        hashSet.add(DatasetType.NETWORK);
        if (!hashSet.contains(datasetVector.getType())) {
            String string10 = InternalResourceSpatialanalyst.loadString("sourceDataset", "RecordsetDatasetTypeIsNotSupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string10);
        }
        if (!hashSet.contains(datasetVector2.getType())) {
            String string11 = InternalResourceSpatialanalyst.loadString("updatedDataset", "RecordsetDatasetTypeIsNotSupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string11);
        }
        for (int i = 0; i < fieldMappingArray.length; ++i) {
            Object object;
            if (fieldMappingArray[i] == null) {
                object = InternalResourceSpatialanalyst.loadString("statisticsFields[" + i + "]", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException((String)object);
            }
            object = fieldMappingArray[i];
            if (((FieldMapping)object).getMergeValueRule() == MergeValueRule.COUNT) continue;
            String string12 = ((FieldMapping)object).getSourceField();
            if (datasetVector.getFieldInfos().indexOf(string12) != -1) continue;
            String string13 = InternalResourceSpatialanalyst.loadString(string12 + " of sourceDataset", "FieldInfo_NameIsNotExist", "spatialanalyst_resources");
            throw new IllegalArgumentException(string13);
        }
        this.a(datasetVector, datasetVector2, spatialQueryMode);
    }

    private void a(DatasetVector datasetVector, DatasetVector datasetVector2, SpatialQueryMode spatialQueryMode) {
        int n = -1;
        int n2 = -1;
        if (datasetVector2.getType().equals((Object)DatasetType.POINT) || datasetVector2.getType().equals((Object)DatasetType.POINT3D) || datasetVector2.getType().equals((Object)DatasetType.POINTEPS)) {
            n = 0;
        } else if (datasetVector2.getType().equals((Object)DatasetType.LINE) || datasetVector2.getType().equals((Object)DatasetType.NETWORK) || datasetVector2.getType().equals((Object)DatasetType.NETWORK3D) || datasetVector2.getType().equals((Object)DatasetType.LINE3D) || datasetVector2.getType().equals((Object)DatasetType.LINEM) || datasetVector2.getType().equals((Object)DatasetType.LINEEPS)) {
            n = 1;
        } else if (datasetVector2.getType().equals((Object)DatasetType.REGION) || datasetVector2.getType().equals((Object)DatasetType.TEXT) || datasetVector2.getType().equals((Object)DatasetType.REGION3D) || datasetVector2.getType().equals((Object)DatasetType.TEXTEPS) || datasetVector2.getType().equals((Object)DatasetType.REGIONEPS) || datasetVector2.getType().equals((Object)DatasetType.VIDEO)) {
            n = 2;
        }
        if (datasetVector.getType().equals((Object)DatasetType.POINT) || datasetVector.getType().equals((Object)DatasetType.POINT3D) || datasetVector.getType().equals((Object)DatasetType.POINTEPS)) {
            n2 = 0;
        } else if (datasetVector.getType().equals((Object)DatasetType.LINE) || datasetVector.getType().equals((Object)DatasetType.LINE3D) || datasetVector.getType().equals((Object)DatasetType.LINEM) || datasetVector.getType().equals((Object)DatasetType.LINEEPS)) {
            n2 = 1;
        } else if (datasetVector.getType().equals((Object)DatasetType.REGION) || datasetVector.getType().equals((Object)DatasetType.REGION3D) || datasetVector.getType().equals((Object)DatasetType.TEXT) || datasetVector.getType().equals((Object)DatasetType.TEXTEPS) || datasetVector.getType().equals((Object)DatasetType.REGIONEPS) || datasetVector.getType().equals((Object)DatasetType.VIDEO)) {
            n2 = 2;
        }
        boolean bl = false;
        if (n == -1 || n2 == -1) {
            String string = InternalResourceSpatialanalyst.loadString("targetDataset", "RecordsetDatasetTypeIsNotSupported", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (spatialQueryMode.equals((Object)SpatialQueryMode.IDENTITY)) {
            if (n != n2) {
                bl = true;
            }
        } else if (spatialQueryMode.equals((Object)SpatialQueryMode.TOUCH)) {
            if (n == 0 && n2 == 0) {
                bl = true;
            }
        } else if (spatialQueryMode.equals((Object)SpatialQueryMode.OVERLAP)) {
            if (n == 0 || n != n2) {
                bl = true;
            }
        } else if (spatialQueryMode.equals((Object)SpatialQueryMode.CROSS)) {
            if (n == 0 || n2 != 1) {
                bl = true;
            }
        } else if (spatialQueryMode.equals((Object)SpatialQueryMode.WITHIN)) {
            if (n < n2) {
                bl = true;
            }
        } else if (spatialQueryMode.equals((Object)SpatialQueryMode.CONTAIN) && n > n2) {
            bl = true;
        }
        if (bl) {
            String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "QueryObjectNotMatchTargetObjectInRelation", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
    }

    public synchronized void addSteppedListener(SteppedListener l) {
        if (this.a == null) {
            this.a = new Vector();
        }
        if (l != null && !this.a.contains(l)) {
            this.a.add(l);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener l) {
        if (this.a != null && this.a.contains(l)) {
            this.a.remove(l);
        }
    }

    protected void fireStepped(SteppedEvent event) {
        if (this.a != null) {
            Vector vector = this.a;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(SpatialJoin source, int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "SpatialJoin";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        SteppedEvent steppedEvent = new SteppedEvent((Object)source, percent, remainTime, title, message, string, bl);
        source.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }
}

