/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.DistanceAnalystNative;
import com.supermap.analyst.spatialanalyst.GridAnalystSetting;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalHandleSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.MathAnalystNative;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.Datasource;
import com.supermap.data.Enum;
import com.supermap.data.GeoRegion;
import com.supermap.data.InternalHandle;
import com.supermap.data.PixelFormat;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedHelper;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

public class MathAnalyst {
    private static transient Vector a;
    private static License b;
    private static GridAnalystSetting c;

    private MathAnalyst() {
        c = null;
    }

    public static GridAnalystSetting getAnalystSetting() {
        return c;
    }

    public static void setAnalystSetting(GridAnalystSetting gridAnalystSetting) {
        if (gridAnalystSetting == null) {
            c = null;
            return;
        }
        if (c == null) {
            c = new GridAnalystSetting();
        }
        c.setBounds(gridAnalystSetting.getBounds());
        c.setBoundsType(gridAnalystSetting.getBoundsType());
        c.setCellSizeType(gridAnalystSetting.getCellSizeType());
        c.setCellSize(gridAnalystSetting.getCellSize());
        c.setOutputDatasource(gridAnalystSetting.getOutputDatasource());
        c.setGridOutputNamePrefix(gridAnalystSetting.getGridOutputNamePrefix());
        c.setVectorOutputNamePrefix(gridAnalystSetting.getVectorOutputNamePrefix());
        c.setValidRegion(gridAnalystSetting.getValidRegion());
        c.setShowProgress(gridAnalystSetting.isShowProgress());
    }

    public static DatasetGrid plus(DatasetGrid firstOperand, DatasetGrid secondOperand, GeoRegion userRegion, Datasource targetDatasource, String targetDatasetName) {
        return MathAnalyst.plus(firstOperand, secondOperand, userRegion, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid plus(DatasetGrid firstOperand, DatasetGrid secondOperand, GeoRegion userRegion, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            MathAnalyst.a();
            if (firstOperand == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)firstOperand) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("firstOperand", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (secondOperand == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)secondOperand) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("secondOperand", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : firstOperand.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = 0L;
            if (userRegion != null) {
                l = InternalHandleSpatialanalyst.getHandle((InternalHandle)userRegion);
            } else if (c != null && c.getValidRegion() != null) {
                l = InternalHandleSpatialanalyst.getHandle((InternalHandle)c.getValidRegion());
            }
            long l2 = MathAnalystNative.jni_New();
            if (l2 == 0L) {
                DatasetGrid datasetGrid = null;
                return datasetGrid;
            }
            boolean bl = false;
            if (null != c) {
                bl = c.isShowProgress();
                Rectangle2D rectangle2D = c.getBounds();
                DistanceAnalystNative.jni_SetTargetBounds(l2, c.getBoundsType().value(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
            }
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)firstOperand);
            long l4 = InternalHandleSpatialanalyst.getHandle((InternalHandle)secondOperand);
            long l5 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l6 = MathAnalystNative.jni_Plus(l2, l3, l4, l, l5, targetDatasetName, bl);
            MathAnalystNative.jni_Delete(l2);
            DatasetGrid datasetGrid = null;
            if (l6 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l6, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)userRegion);
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetGrid minus(DatasetGrid firstOperand, DatasetGrid secondOperand, GeoRegion userRegion, Datasource targetDatasource, String targetDatasetName) {
        return MathAnalyst.minus(firstOperand, secondOperand, userRegion, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid minus(DatasetGrid firstOperand, DatasetGrid secondOperand, GeoRegion userRegion, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            MathAnalyst.a();
            if (firstOperand == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)firstOperand) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("firstOperand", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (secondOperand == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)secondOperand) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("secondOperand", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : firstOperand.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = 0L;
            if (userRegion != null) {
                l = InternalHandleSpatialanalyst.getHandle((InternalHandle)userRegion);
            } else if (c != null && c.getValidRegion() != null) {
                l = InternalHandleSpatialanalyst.getHandle((InternalHandle)c.getValidRegion());
            }
            long l2 = MathAnalystNative.jni_New();
            if (l2 == 0L) {
                DatasetGrid datasetGrid = null;
                return datasetGrid;
            }
            boolean bl = false;
            if (null != c) {
                bl = c.isShowProgress();
                Rectangle2D rectangle2D = c.getBounds();
                DistanceAnalystNative.jni_SetTargetBounds(l2, c.getBoundsType().value(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
            }
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)firstOperand);
            long l4 = InternalHandleSpatialanalyst.getHandle((InternalHandle)secondOperand);
            long l5 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l6 = MathAnalystNative.jni_Mius(l2, l3, l4, l, l5, targetDatasetName, bl);
            MathAnalystNative.jni_Delete(l2);
            DatasetGrid datasetGrid = null;
            if (l6 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l6, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)userRegion);
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetGrid multiply(DatasetGrid firstOperand, DatasetGrid secondOperand, GeoRegion userRegion, Datasource targetDatasource, String targetDatasetName) {
        return MathAnalyst.multiply(firstOperand, secondOperand, userRegion, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid multiply(DatasetGrid firstOperand, DatasetGrid secondOperand, GeoRegion userRegion, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            MathAnalyst.a();
            if (firstOperand == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)firstOperand) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("firstOperand", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (secondOperand == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)secondOperand) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("secondOperand", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : firstOperand.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = 0L;
            if (userRegion != null) {
                l = InternalHandleSpatialanalyst.getHandle((InternalHandle)userRegion);
            } else if (c != null && c.getValidRegion() != null) {
                l = InternalHandleSpatialanalyst.getHandle((InternalHandle)c.getValidRegion());
            }
            long l2 = MathAnalystNative.jni_New();
            if (l2 == 0L) {
                DatasetGrid datasetGrid = null;
                return datasetGrid;
            }
            boolean bl = false;
            if (null != c) {
                bl = c.isShowProgress();
                Rectangle2D rectangle2D = c.getBounds();
                DistanceAnalystNative.jni_SetTargetBounds(l2, c.getBoundsType().value(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
            }
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)firstOperand);
            long l4 = InternalHandleSpatialanalyst.getHandle((InternalHandle)secondOperand);
            long l5 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l6 = MathAnalystNative.jni_Multiply(l2, l3, l4, l, l5, targetDatasetName, bl);
            MathAnalystNative.jni_Delete(l2);
            DatasetGrid datasetGrid = null;
            if (l6 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l6, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)userRegion);
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetGrid divide(DatasetGrid firstOperand, DatasetGrid secondOperand, GeoRegion userRegion, Datasource targetDatasource, String targetDatasetName) {
        return MathAnalyst.divide(firstOperand, secondOperand, userRegion, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid divide(DatasetGrid firstOperand, DatasetGrid secondOperand, GeoRegion userRegion, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            MathAnalyst.a();
            if (firstOperand == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)firstOperand) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("firstOperand", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (secondOperand == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)secondOperand) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("secondOperand", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : firstOperand.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = 0L;
            if (userRegion != null) {
                l = InternalHandleSpatialanalyst.getHandle((InternalHandle)userRegion);
            } else if (c != null && c.getValidRegion() != null) {
                l = InternalHandleSpatialanalyst.getHandle((InternalHandle)c.getValidRegion());
            }
            long l2 = MathAnalystNative.jni_New();
            if (l2 == 0L) {
                DatasetGrid datasetGrid = null;
                return datasetGrid;
            }
            boolean bl = false;
            if (null != c) {
                bl = c.isShowProgress();
                Rectangle2D rectangle2D = c.getBounds();
                DistanceAnalystNative.jni_SetTargetBounds(l2, c.getBoundsType().value(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
            }
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)firstOperand);
            long l4 = InternalHandleSpatialanalyst.getHandle((InternalHandle)secondOperand);
            long l5 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l6 = MathAnalystNative.jni_Divide(l2, l3, l4, l, l5, targetDatasetName, bl);
            MathAnalystNative.jni_Delete(l2);
            DatasetGrid datasetGrid = null;
            if (l6 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l6, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)userRegion);
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetGrid execute(String expression, GeoRegion userRegion, PixelFormat pixelFormat, boolean isZip, boolean isIgnoreNoValue, Datasource targetDatasource, String targetDatasetName) {
        return MathAnalyst.execute(expression, userRegion, pixelFormat, isZip, isIgnoreNoValue, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid execute(String expression, GeoRegion userRegion, PixelFormat pixelFormat, boolean isZip, boolean isIgnoreNoValue, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            MathAnalyst.a();
            if (expression == null || expression.length() == 0) {
                String string = InternalResourceSpatialanalyst.loadString("expression", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                if (c != null && c.getOutputDatasource() != null) {
                    targetDatasource = c.getOutputDatasource();
                } else {
                    String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = 0L;
            if (userRegion != null) {
                l = InternalHandleSpatialanalyst.getHandle((InternalHandle)userRegion);
            } else if (c != null && c.getValidRegion() != null) {
                l = InternalHandleSpatialanalyst.getHandle((InternalHandle)c.getValidRegion());
            }
            long l2 = MathAnalystNative.jni_New();
            if (l2 == 0L) {
                DatasetGrid datasetGrid = null;
                return datasetGrid;
            }
            boolean bl = false;
            if (null != c) {
                bl = c.isShowProgress();
                Rectangle2D rectangle2D = c.getBounds();
                DistanceAnalystNative.jni_SetTargetBounds(l2, c.getBoundsType().value(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
            }
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            int n = InternalEnum.getUGCValue((Enum)pixelFormat);
            long l4 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource.getWorkspace());
            long l5 = MathAnalystNative.jni_Execute(l2, expression, l4, l, n, isZip, isIgnoreNoValue, l3, targetDatasetName, bl);
            MathAnalystNative.jni_Delete(l2);
            DatasetGrid datasetGrid = null;
            if (l5 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l5, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)userRegion);
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetGrid execute(String expression, GeoRegion userRegion, PixelFormat pixelFormat, boolean isZip, boolean isIgnoreNoValue, Datasource[] sourceDatasources, Datasource targetDatasource, String targetDatasetName) {
        return MathAnalyst.execute(expression, userRegion, pixelFormat, isZip, isIgnoreNoValue, sourceDatasources, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid execute(String expression, GeoRegion userRegion, PixelFormat pixelFormat, boolean isZip, boolean isIgnoreNoValue, Datasource[] sourceDatasources, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (expression == null || expression.length() == 0) {
                String string = InternalResourceSpatialanalyst.loadString("expression", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                if (c != null && c.getOutputDatasource() != null) {
                    targetDatasource = c.getOutputDatasource();
                } else {
                    String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            int n = sourceDatasources.length;
            for (int i = 0; i < n; ++i) {
                if (null != sourceDatasources[i] && InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasources[i]) != 0L) continue;
                String string = InternalResourceSpatialanalyst.loadString("sourceDatasources[" + i + "]", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long[] lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasources[i]);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = 0L;
            if (userRegion != null) {
                l = InternalHandleSpatialanalyst.getHandle((InternalHandle)userRegion);
            } else if (c != null && c.getValidRegion() != null) {
                l = InternalHandleSpatialanalyst.getHandle((InternalHandle)c.getValidRegion());
            }
            long l2 = MathAnalystNative.jni_New();
            if (l2 == 0L) {
                DatasetGrid datasetGrid = null;
                return datasetGrid;
            }
            boolean bl = true;
            if (null != c) {
                bl = c.isShowProgress();
                Rectangle2D rectangle2D = c.getBounds();
                DistanceAnalystNative.jni_SetTargetBounds(l2, c.getBoundsType().value(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
            }
            if (listeners == null || listeners.length == 0) {
                bl = false;
            }
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            int n2 = InternalEnum.getUGCValue((Enum)pixelFormat);
            long l4 = MathAnalystNative.jni_GPExecute(l2, expression, l, n2, isZip, isIgnoreNoValue, lArray, l3, targetDatasetName, bl);
            MathAnalystNative.jni_Delete(l2);
            DatasetGrid datasetGrid = null;
            if (l4 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)userRegion);
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetGrid toInt(DatasetGrid sourceDataset, GeoRegion userRegion, Datasource targetDatasource, String targetDatasetName) {
        return MathAnalyst.toInt(sourceDataset, userRegion, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid toInt(DatasetGrid sourceDataset, GeoRegion userRegion, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            MathAnalyst.a();
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : sourceDataset.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = 0L;
            if (userRegion != null) {
                l = InternalHandleSpatialanalyst.getHandle((InternalHandle)userRegion);
            } else if (c != null && c.getValidRegion() != null) {
                l = InternalHandleSpatialanalyst.getHandle((InternalHandle)c.getValidRegion());
            }
            long l2 = MathAnalystNative.jni_New();
            if (l2 == 0L) {
                DatasetGrid datasetGrid = null;
                return datasetGrid;
            }
            boolean bl = false;
            if (null != c) {
                bl = c.isShowProgress();
                Rectangle2D rectangle2D = c.getBounds();
                DistanceAnalystNative.jni_SetTargetBounds(l2, c.getBoundsType().value(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
            }
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            long l4 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l5 = MathAnalystNative.jni_Int(l2, l3, l, l4, targetDatasetName, bl);
            MathAnalystNative.jni_Delete(l2);
            DatasetGrid datasetGrid = null;
            if (l5 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l5, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)userRegion);
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetGrid toFloat(DatasetGrid sourceDataset, GeoRegion userRegion, Datasource targetDatasource, String targetDatasetName) {
        return MathAnalyst.toFloat(sourceDataset, userRegion, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid toFloat(DatasetGrid sourceDataset, GeoRegion userRegion, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            MathAnalyst.a();
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : sourceDataset.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = 0L;
            if (userRegion != null) {
                l = InternalHandleSpatialanalyst.getHandle((InternalHandle)userRegion);
            } else if (c != null && c.getValidRegion() != null) {
                l = InternalHandleSpatialanalyst.getHandle((InternalHandle)c.getValidRegion());
            }
            long l2 = MathAnalystNative.jni_New();
            if (l2 == 0L) {
                DatasetGrid datasetGrid = null;
                return datasetGrid;
            }
            boolean bl = false;
            if (null != c) {
                bl = c.isShowProgress();
                Rectangle2D rectangle2D = c.getBounds();
                DistanceAnalystNative.jni_SetTargetBounds(l2, c.getBoundsType().value(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
            }
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            long l4 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l5 = MathAnalystNative.jni_Float(l2, l3, l, l4, targetDatasetName, bl);
            MathAnalystNative.jni_Delete(l2);
            DatasetGrid datasetGrid = null;
            if (l5 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l5, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)userRegion);
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetGrid executeFromXML(String xmlFileName, Datasource targetDatasource, String targetDatasetName) {
        return MathAnalyst.executeFromXML(xmlFileName, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid executeFromXML(String xmlFileName, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            MathAnalyst.a();
            if (xmlFileName == null || xmlFileName.length() == 0) {
                String string = InternalResourceSpatialanalyst.loadString("xmlFileName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                if (c != null && c.getOutputDatasource() != null) {
                    targetDatasource = c.getOutputDatasource();
                } else {
                    String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = MathAnalystNative.jni_New();
            if (l == 0L) {
                DatasetGrid datasetGrid = null;
                return datasetGrid;
            }
            boolean bl = false;
            if (null != c) {
                bl = c.isShowProgress();
                Rectangle2D rectangle2D = c.getBounds();
                DistanceAnalystNative.jni_SetTargetBounds(l, c.getBoundsType().value(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
            }
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource.getWorkspace());
            long l4 = MathAnalystNative.jni_ExecuteFromXML(l, xmlFileName, l3, l2, targetDatasetName, bl);
            MathAnalystNative.jni_Delete(l);
            DatasetGrid datasetGrid = null;
            if (l4 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static boolean toXMLFile(String xmlFileName, String expression, GeoRegion userRegion, PixelFormat pixelFormat, boolean isZip, boolean isIgnoreNoValue) {
        if (xmlFileName == null || xmlFileName.length() == 0) {
            String string = InternalResourceSpatialanalyst.loadString("xmlFileName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (expression == null || expression.length() == 0) {
            String string = InternalResourceSpatialanalyst.loadString("expression", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = 0L;
        if (userRegion != null) {
            l = InternalHandleSpatialanalyst.getHandle((InternalHandle)userRegion);
        }
        int n = InternalEnum.getUGCValue((Enum)pixelFormat);
        boolean bl = MathAnalystNative.jni_ToXMLFile(xmlFileName, expression, l, n, isZip, isIgnoreNoValue);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)userRegion);
        return bl;
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (a == null) {
            a = new Vector();
        }
        if (!a.contains(l)) {
            a.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (a != null && a.contains(l)) {
            a.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (a != null) {
            Vector vector = a;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "MathAnalyst";
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        SteppedHelper.fire((Collection)a, (SteppedEvent)steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a() {
        int n = -1;
        Object object = b;
        synchronized (object) {
            n = b.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        b = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

