/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.DensityAnalystParameterNative;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import com.supermap.analyst.spatialanalyst.NeighbourShape;
import com.supermap.analyst.spatialanalyst.NeighbourShapeAnnulus;
import com.supermap.analyst.spatialanalyst.NeighbourShapeCircle;
import com.supermap.analyst.spatialanalyst.NeighbourShapeRectangle;
import com.supermap.analyst.spatialanalyst.NeighbourShapeWedge;
import com.supermap.analyst.spatialanalyst.NeighbourStatisticsParameterNative;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Rectangle2D;

public class DensityAnalystParameter
extends InternalHandleDisposable {
    private NeighbourShape a = null;

    public DensityAnalystParameter() {
        super.setHandle(DensityAnalystParameterNative.jni_New(), true);
        this.setBounds(Rectangle2D.getEMPTY());
    }

    public DensityAnalystParameter(double resolution, double searchRadius) {
        super.setHandle(DensityAnalystParameterNative.jni_New(), true);
        this.setResolution(resolution);
        this.setSearchRadius(searchRadius);
        this.setBounds(Rectangle2D.getEMPTY());
    }

    public double getResolution() {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getResolution()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return DensityAnalystParameterNative.jni_GetResolution(this.getHandle());
    }

    public void setResolution(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("setResolution(double value)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResourceSpatialanalyst.loadString("value", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        DensityAnalystParameterNative.jni_SetResolution(this.getHandle(), value);
    }

    public double getSearchRadius() {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getSearchRadius()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return DensityAnalystParameterNative.jni_GetSearchRadius(this.getHandle());
    }

    public void setSearchRadius(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("setSearchRadius(double value)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResourceSpatialanalyst.loadString("value", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        DensityAnalystParameterNative.jni_SetSearchRadius(this.getHandle(), value);
    }

    public NeighbourShape getSearchNeighbourhood() {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getSearchNeighbourhood()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this.a;
    }

    public void setSearchNeighbourhood(NeighbourShape value) {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getSearchNeighbourhood()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        long l = NeighbourStatisticsParameterNative.jni_New();
        int n = InternalEnum.getUGCValue(value.getUnitType());
        NeighbourStatisticsParameterNative.jni_SetUnitType(l, n);
        int n2 = InternalEnum.getUGCValue(value.getShapeType());
        NeighbourStatisticsParameterNative.jni_SetShapeType(l, n2);
        switch (n2) {
            case 1: {
                NeighbourShapeRectangle neighbourShapeRectangle = (NeighbourShapeRectangle)value;
                NeighbourStatisticsParameterNative.jni_SetWidthHeight(l, neighbourShapeRectangle.getWidth(), neighbourShapeRectangle.getHeight());
                break;
            }
            case 2: {
                NeighbourShapeCircle neighbourShapeCircle = (NeighbourShapeCircle)value;
                NeighbourStatisticsParameterNative.jni_SetRadius(l, neighbourShapeCircle.getRadius());
                break;
            }
            case 3: {
                NeighbourShapeAnnulus neighbourShapeAnnulus = (NeighbourShapeAnnulus)value;
                NeighbourStatisticsParameterNative.jni_SetAnnulusRadius(l, neighbourShapeAnnulus.getInnerRadius(), neighbourShapeAnnulus.getOuterRadius());
                break;
            }
            case 4: {
                NeighbourShapeWedge neighbourShapeWedge = (NeighbourShapeWedge)value;
                NeighbourStatisticsParameterNative.jni_SetRadius(l, neighbourShapeWedge.getRadius());
                NeighbourStatisticsParameterNative.jni_SetWedgeAngle(l, neighbourShapeWedge.getStartAngle(), neighbourShapeWedge.getEndAngle());
                break;
            }
        }
        DensityAnalystParameterNative.jni_SetSearchNeighbourhood(this.getHandle(), l);
        NeighbourStatisticsParameterNative.jni_Dispose(l);
        this.a = value;
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getBounds()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        DensityAnalystParameterNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setBounds(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("setBounds(Rectangle2D rectangle2D)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (rectangle2D == null) {
            rectangle2D = Rectangle2D.getEMPTY();
        }
        double[] dArray = new double[]{rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop()};
        DensityAnalystParameterNative.jni_SetBounds(this.getHandle(), dArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Bounds={");
        stringBuffer.append(this.getBounds().toString());
        stringBuffer.append(",Resolution=");
        stringBuffer.append(this.getResolution());
        stringBuffer.append(",SearchRadius=");
        stringBuffer.append(this.getSearchRadius());
        return stringBuffer.toString();
    }

    public void dispose() {
        if (super.getHandle() != 0L) {
            DensityAnalystParameterNative.jni_Dispose(this.getHandle());
            this.setHandle(0L);
        }
    }
}

