/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.InternalHandleSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import com.supermap.data.DatasetGrid;
import com.supermap.data.Datasource;
import com.supermap.data.InternalHandle;
import com.supermap.data.PixelFormat;
import java.util.ArrayList;

public class CellularAutomataParameter {
    private DatasetGrid a;
    private ArrayList<DatasetGrid> b;
    private Datasource c;
    private String d;
    private boolean e;
    private int f;
    private int g;
    private int h;
    private String i;
    private int j;

    protected void Reset(CellularAutomataParameter para) {
        this.a = para.a;
        this.b = para.b;
        this.c = para.c;
        this.d = para.d;
        this.e = para.e;
        this.f = para.f;
        this.g = para.g;
        this.h = para.h;
        this.i = para.i;
        this.j = para.j;
    }

    public CellularAutomataParameter() {
        this.a = null;
        this.b = null;
        this.c = null;
        this.e = false;
        this.f = 10;
        this.g = 10;
        this.h = 0;
        this.j = 10;
    }

    public CellularAutomataParameter(CellularAutomataParameter para) {
        this.Reset(para);
    }

    protected static void CheckParameter(CellularAutomataParameter para) {
        if (para == null) {
            String string = InternalResourceSpatialanalyst.loadString("CellularAutomataParameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (null == para.getCellGrid() || InternalHandleSpatialanalyst.getHandle((InternalHandle)para.getCellGrid()) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("CellularAutomataParameter.getCellGrid()", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetGrid datasetGrid = para.getCellGrid();
        if (datasetGrid.getPixelFormat() != PixelFormat.BIT8 && datasetGrid.getPixelFormat() != PixelFormat.BIT16 && datasetGrid.getPixelFormat() != PixelFormat.BIT32 && datasetGrid.getPixelFormat() != PixelFormat.BIT64 && datasetGrid.getPixelFormat() != PixelFormat.UBIT1 && datasetGrid.getPixelFormat() != PixelFormat.UBIT4 && datasetGrid.getPixelFormat() != PixelFormat.UBIT8 && datasetGrid.getPixelFormat() != PixelFormat.UBIT16 && datasetGrid.getPixelFormat() != PixelFormat.UBIT32) {
            String string = InternalResourceSpatialanalyst.loadString("CellularAutomataParameter.getCellGrid()", "ZonalDataset_UnsupportedDatasetType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == para.getSpatialVariableGrids() || para.getSpatialVariableGrids().length == 0) {
            String string = InternalResourceSpatialanalyst.loadString("CellularAutomataParameter.getSpatialVariableGrids()", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (para.IsSave()) {
            if (para.getSaveFrequency() <= 0) {
                String string = InternalResourceSpatialanalyst.loadString("CellularAutomataParameter.getSaveFrequency()", "GlobalGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == para.getOutputDataSource() || 0L == InternalHandleSpatialanalyst.getHandle((InternalHandle)para.getOutputDataSource())) {
                String string = InternalResourceSpatialanalyst.loadString("CellularAutomataParameter.getOutputDataSource()", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (para.getOutputDatasetName() == null || para.getOutputDatasetName().trim().equalsIgnoreCase("")) {
                String string = InternalResourceSpatialanalyst.loadString("CellularAutomataParameter.getOutputDatasetName()", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (!para.getOutputDataSource().getDatasets().isAvailableDatasetName(para.getOutputDatasetName())) {
                String string = InternalResourceSpatialanalyst.loadString("CellularAutomataParameter.getOutputDatasetName()", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if (para.getFlushFilePathName() != null && !para.getFlushFilePathName().trim().equalsIgnoreCase("")) {
            if (para.getFlushFrequency() <= 0) {
                String string = InternalResourceSpatialanalyst.loadString("CellularAutomataParameter.getFlushFrequency()", "GlobalGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (!para.getFlushFilePathName().endsWith(".tif")) {
                String string = InternalResourceSpatialanalyst.loadString("CellularAutomataParameter.getFlushFilePathName()", "ArgumentInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if (para.getSimulationCount() <= 0) {
            String string = InternalResourceSpatialanalyst.loadString("CellularAutomataParameter.getSimulationCount()", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (para.getIterations() <= 0) {
            String string = InternalResourceSpatialanalyst.loadString("CellularAutomataParameter.getIterations()", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
    }

    public DatasetGrid getCellGrid() {
        return this.a;
    }

    public void setCellGrid(DatasetGrid value) {
        if (value == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)value) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("CellGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.a = value;
    }

    public DatasetGrid[] getSpatialVariableGrids() {
        if (this.b == null) {
            return null;
        }
        int n = this.b.size();
        DatasetGrid[] datasetGridArray = new DatasetGrid[n];
        for (int i = 0; i < n; ++i) {
            datasetGridArray[i] = this.b.get(i);
        }
        return datasetGridArray;
    }

    public void setSpatialVariableGrids(DatasetGrid[] value) {
        int n;
        if (value == null) {
            String string = InternalResourceSpatialanalyst.loadString("SpatialVariableGrids", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = value.length;
        for (n = 0; n < n2; ++n) {
            if (value[n] != null && InternalHandleSpatialanalyst.getHandle((InternalHandle)value[n]) != 0L) continue;
            String string = InternalResourceSpatialanalyst.loadString("value[" + n + "]", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.b != null) {
            this.b.clear();
        } else {
            this.b = new ArrayList();
        }
        for (n = 0; n < n2; ++n) {
            this.b.add(value[n]);
        }
    }

    public Datasource getOutputDataSource() {
        return this.c;
    }

    public void setOutputDataSource(Datasource value) {
        if (value == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)value) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("OutputDataSource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.c = value;
    }

    public String getOutputDatasetName() {
        return this.d;
    }

    public void setOutputDatasetName(String value) {
        if (value == null || value.trim().equalsIgnoreCase("")) {
            String string = InternalResourceSpatialanalyst.loadString("OutputDatasetName", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.d = value;
    }

    public boolean IsSave() {
        return this.e;
    }

    public void setSave(boolean value) {
        this.e = value;
    }

    public int getSaveFrequency() {
        return this.f;
    }

    public void setSaveFrequency(int value) {
        if (value <= 0) {
            String string = InternalResourceSpatialanalyst.loadString("SaveFrequency", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.f = value;
    }

    public int getFlushFrequency() {
        return this.g;
    }

    public void setFlushFrequency(int value) {
        if (value <= 0) {
            String string = InternalResourceSpatialanalyst.loadString("FlushFrequency", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.g = value;
    }

    public int getSimulationCount() {
        return this.h;
    }

    public void setSimulationCount(int value) {
        if (value <= 0) {
            String string = InternalResourceSpatialanalyst.loadString("SimulationCount", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.h = value;
    }

    public String getFlushFilePathName() {
        return this.i;
    }

    public void setFlushFilePathName(String value) {
        if (value == null || value.trim().equalsIgnoreCase("")) {
            String string = InternalResourceSpatialanalyst.loadString("FlushFilePathName", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.i = value;
    }

    public int getIterations() {
        return this.j;
    }

    public void setIterations(int value) {
        if (value <= 0) {
            String string = InternalResourceSpatialanalyst.loadString("Iterations", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.j = value;
    }
}

