/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.geotools.resources.i18n.Errors;

public class URLs {
    static final boolean IS_WINDOWS_OS = System.getProperty("os.name").toUpperCase().contains("WINDOWS");

    public static URL changeUrlExt(URL url, String postfix) throws IllegalArgumentException {
        String a = url.toString();
        int lastDotPos = a.lastIndexOf(46);
        if (lastDotPos >= 0) {
            a = a.substring(0, lastDotPos);
        }
        a = a + "." + postfix;
        try {
            return new URL(a);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Failed to create a new URL for " + url + " with new extension " + postfix, e);
        }
    }

    public static URL extendUrl(URL base, String extension) throws MalformedURLException {
        if (base == null) {
            throw new NullPointerException(Errors.format(143, "base"));
        }
        if (extension == null) {
            throw new NullPointerException(Errors.format(143, "extension"));
        }
        String a = base.toString();
        if (!a.endsWith("/")) {
            a = a + "/";
        }
        a = a + extension;
        return new URL(a);
    }

    public static URL fileToUrl(File file) {
        try {
            String string = file.toURI().toASCIIString();
            if (string.contains("+")) {
                string = string.replace("+", "%2B");
            }
            if (string.contains(" ")) {
                string = string.replace(" ", "%20");
            }
            return new URL(string);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static URL getParentUrl(URL url) throws MalformedURLException {
        String a = url.toString();
        int lastDotPos = a.lastIndexOf(47);
        if (lastDotPos >= 0) {
            a = a.substring(0, lastDotPos);
        }
        if (a.endsWith("!")) {
            a = a + "/";
        }
        return new URL(a);
    }

    public static File urlToFile(URL url) {
        String path3;
        if (!"file".equals(url.getProtocol())) {
            return null;
        }
        String string = url.toString();
        if (url.getQuery() != null) {
            string = string.substring(0, string.indexOf("?"));
        }
        if (string.contains("+")) {
            string = string.replace("+", "%2B");
        }
        try {
            string = URLDecoder.decode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("UTF-8 encoding not supported", e);
        }
        String simplePrefix = "file:/";
        String standardPrefix = "file://";
        if (IS_WINDOWS_OS && string.startsWith(standardPrefix)) {
            path3 = string.substring(standardPrefix.length() - 2);
            File f = new File(path3);
            if (!f.exists()) {
                path3 = path3.substring(2, path3.length());
            }
        } else if (string.startsWith(standardPrefix)) {
            path3 = string.substring(standardPrefix.length());
        } else if (string.startsWith(simplePrefix)) {
            path3 = string.substring(simplePrefix.length() - 1);
        } else {
            String auth = url.getAuthority();
            String path2 = url.getPath();
            try {
                path2 = URLDecoder.decode(path2, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("UTF-8 encoding not supported", e);
            }
            path3 = auth != null && !auth.equals("") ? "//" + auth + path2 : path2;
        }
        return new File(path3);
    }
}

