/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.Collections;
import java.util.List;
import org.geotools.filter.ConstantExpression;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Graphic;
import org.geotools.styling.Mark;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbol;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Displacement;
import org.opengis.style.GraphicStroke;
import org.opengis.style.GraphicalSymbol;

abstract class ConstantGraphic
implements Graphic {
    ConstantGraphic() {
    }

    private void cannotModifyConstant() {
        throw new UnsupportedOperationException("Constant Graphic may not be modified");
    }

    @Override
    public void setDisplacement(Displacement offset) {
        this.cannotModifyConstant();
    }

    @Override
    public void setExternalGraphics(ExternalGraphic[] externalGraphics) {
        this.cannotModifyConstant();
    }

    @Override
    public void addExternalGraphic(ExternalGraphic externalGraphic) {
        this.cannotModifyConstant();
    }

    @Override
    public void setMarks(Mark[] marks) {
        this.cannotModifyConstant();
    }

    @Override
    public void addMark(Mark mark) {
        this.cannotModifyConstant();
    }

    @Override
    public void setGap(Expression gap) {
        this.cannotModifyConstant();
    }

    @Override
    public void setInitialGap(Expression initialGap) {
        this.cannotModifyConstant();
    }

    @Override
    public void setSymbols(Symbol[] symbols) {
        this.cannotModifyConstant();
    }

    @Override
    public void addSymbol(Symbol symbol) {
        this.cannotModifyConstant();
    }

    @Override
    public void setOpacity(Expression opacity) {
        this.cannotModifyConstant();
    }

    @Override
    public void setSize(Expression size) {
        this.cannotModifyConstant();
    }

    @Override
    public void setRotation(Expression rotation) {
        this.cannotModifyConstant();
    }

    public void setAnchorPoint(AnchorPoint anchor) {
        this.cannotModifyConstant();
    }

    public Object accept(org.opengis.style.StyleVisitor visitor, Object data) {
        return visitor.visit((GraphicStroke)this, data);
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public List<GraphicalSymbol> graphicalSymbols() {
        return Collections.emptyList();
    }

    @Override
    public AnchorPoint getAnchorPoint() {
        return AnchorPoint.DEFAULT;
    }

    @Override
    public void setAnchorPoint(org.opengis.style.AnchorPoint anchorPoint) {
        this.cannotModifyConstant();
    }

    @Override
    public Expression getGap() {
        return ConstantExpression.constant(0);
    }

    @Override
    public Expression getInitialGap() {
        return ConstantExpression.constant(0);
    }
}

