/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.BoundsType;
import com.supermap.analyst.spatialanalyst.ConversionAnalystNative;
import com.supermap.analyst.spatialanalyst.ConversionAnalystParameter;
import com.supermap.analyst.spatialanalyst.GridAnalystSetting;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasetImage;
import com.supermap.analyst.spatialanalyst.InternalDatasetVector;
import com.supermap.analyst.spatialanalyst.InternalDatasetVolume;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalGeometrySpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalHandleSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVolume;
import com.supermap.data.Datasource;
import com.supermap.data.Enum;
import com.supermap.data.FieldInfos;
import com.supermap.data.FieldType;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoLine3D;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeoRegion3D;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.PixelFormat;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedHelper;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

public class ConversionAnalyst {
    private static transient Vector a;
    private static License b;
    private static GridAnalystSetting c;

    private ConversionAnalyst() {
        c = null;
    }

    public static GridAnalystSetting getAnalystSetting() {
        return c;
    }

    public static void setAnalystSetting(GridAnalystSetting gridAnalystSetting) {
        if (gridAnalystSetting == null) {
            c = null;
            return;
        }
        if (c == null) {
            c = new GridAnalystSetting();
        }
        c.setBounds(gridAnalystSetting.getBounds());
        c.setBoundsType(gridAnalystSetting.getBoundsType());
        c.setCellSizeType(gridAnalystSetting.getCellSizeType());
        c.setCellSize(gridAnalystSetting.getCellSize());
        c.setOutputDatasource(gridAnalystSetting.getOutputDatasource());
        c.setGridOutputNamePrefix(gridAnalystSetting.getGridOutputNamePrefix());
        c.setVectorOutputNamePrefix(gridAnalystSetting.getVectorOutputNamePrefix());
        c.setValidRegion(gridAnalystSetting.getValidRegion());
        c.setShowProgress(gridAnalystSetting.isShowProgress());
    }

    public static DatasetGrid vectorToRaster(ConversionAnalystParameter parameter) {
        return ConversionAnalyst.vectorToRaster(parameter, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid vectorToRaster(ConversionAnalystParameter parameter, SteppedListener ... listeners) {
        try {
            String string;
            SteppedHelper.addListeners((SteppedListener[])listeners);
            ConversionAnalyst.a();
            if (parameter == null) {
                String string2 = InternalResourceSpatialanalyst.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string2);
            }
            Dataset dataset = parameter.getSourceDataset();
            if (dataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)dataset) == 0L) {
                String string3 = InternalResourceSpatialanalyst.loadString("srcDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string3);
            }
            if (dataset.getType() != DatasetType.POINT && dataset.getType() != DatasetType.LINE && dataset.getType() != DatasetType.REGION) {
                String string4 = InternalResourceSpatialanalyst.loadString("srcDataset DatasetType", "GlobalUnsportedType", "spatialanalyst_resources");
                throw new NullPointerException(string4);
            }
            Datasource datasource = parameter.getTargetDatasource();
            if (datasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource) == 0L) {
                datasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : dataset.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource) == 0L) {
                String string5 = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string5);
            }
            String string6 = parameter.getTargetDatasetName();
            if (null == string6) {
                String string7 = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string7);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                string6 = c.getGridOutputNamePrefix() + string6;
            }
            if (!datasource.getDatasets().isAvailableDatasetName(string6)) {
                String string8 = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string8);
            }
            double d = parameter.getCellSize();
            boolean bl = true;
            Rectangle2D rectangle2D = new Rectangle2D(0.0, 0.0, 0.0, 0.0);
            int n = BoundsType.INTERSECTION.value();
            if (null != c) {
                bl = c.isShowProgress();
                n = c.getBoundsType().value();
                rectangle2D = c.getBounds();
                if (d <= 0.0) {
                    d = c.getCellSize();
                }
            }
            if (listeners == null || listeners.length == 0) {
                bl = false;
            }
            if (null == (string = parameter.getValueFieldName()) || string.isEmpty()) {
                String string9 = InternalResourceSpatialanalyst.loadString("ValueFieldName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string9);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)dataset);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource);
            long l3 = 0L;
            GeoRegion geoRegion = parameter.getClipRegion();
            if (geoRegion != null) {
                l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)geoRegion);
            } else if (c != null && c.getValidRegion() != null) {
                l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)c.getValidRegion());
            }
            PixelFormat pixelFormat = parameter.getPixelFormat();
            int n2 = InternalEnum.getUGCValue((Enum)pixelFormat);
            double d2 = parameter.getNoValue();
            long l4 = ConversionAnalystNative.jni_VectorToRaster(l, string, d, n2, d2, l3, l2, string6, bl, n, rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop(), parameter.isAllTouched());
            DatasetGrid datasetGrid = null;
            if (l4 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l4, datasource);
                InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid);
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)parameter);
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetVector rasterToVector(ConversionAnalystParameter parameter) {
        return ConversionAnalyst.rasterToVector(parameter, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetVector rasterToVector(ConversionAnalystParameter parameter, SteppedListener ... listeners) {
        try {
            String string;
            SteppedHelper.addListeners((SteppedListener[])listeners);
            ConversionAnalyst.a();
            if (parameter == null) {
                String string2 = InternalResourceSpatialanalyst.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string2);
            }
            if (parameter.getSourceDataset() == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)parameter.getSourceDataset()) == 0L) {
                String string3 = InternalResourceSpatialanalyst.loadString("getSourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string3);
            }
            if (parameter.getSourceDataset().getType() != DatasetType.IMAGE && parameter.getSourceDataset().getType() != DatasetType.GRID) {
                String string4 = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentTypeInvalid", "spatialanalyst_resources");
                throw new NullPointerException(string4);
            }
            Datasource datasource = parameter.getTargetDatasource();
            if (datasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource) == 0L) {
                datasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : parameter.getSourceDataset().getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource) == 0L) {
                String string5 = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string5);
            }
            String string6 = parameter.getTargetDatasetName();
            if (null == string6) {
                String string7 = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string7);
            }
            if (null != c && null != c.getVectorOutputNamePrefix()) {
                string6 = c.getVectorOutputNamePrefix() + string6;
            }
            if (!datasource.getDatasets().isAvailableDatasetName(string6)) {
                String string8 = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string8);
            }
            boolean bl = true;
            if (null != c) {
                bl = c.isShowProgress();
            }
            if (listeners == null || listeners.length == 0) {
                bl = false;
            }
            if ((string = parameter.getValueFieldName()) == null || string.length() == 0) {
                String string9 = InternalResourceSpatialanalyst.loadString("valueField", "StringIsNullOrEmpty", "spatialanalyst_resources");
                throw new IllegalArgumentException(string9);
            }
            if (string != null && ConversionAnalyst.a(string)) {
                String string10 = InternalResourceSpatialanalyst.loadString("valueField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new UnsupportedOperationException(string10);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)parameter.getSourceDataset());
            long l2 = 0L;
            if (parameter.getClipRegion() != null) {
                l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)parameter.getClipRegion());
            } else if (c != null && c.getValidRegion() != null) {
                l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)c.getValidRegion());
            }
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource);
            int n = InternalEnum.getUGCValue((Enum)parameter.getTargetDatasetType());
            long l4 = parameter.getSpecifiedValue();
            double d = parameter.getSpecifiedValueTolerance();
            long l5 = parameter.getBackOrNoValue();
            double d2 = parameter.getBackOrNoValueTolerance();
            int n2 = InternalEnum.getUGCValue(parameter.getSmoothMethod());
            int n3 = parameter.getSmoothDegree();
            boolean bl2 = parameter.isThinRaster();
            long l6 = ConversionAnalystNative.jni_RasterToVector(l, n, string, l4, d, l2, l5, d2, bl2, n2, n3, l3, string6, bl);
            DatasetVector datasetVector = null;
            if (l6 != 0L) {
                datasetVector = InternalDatasetVector.createInstance(l6, datasource);
                InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)parameter);
            DatasetVector datasetVector2 = datasetVector;
            return datasetVector2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static GeoRegion extractRegion(Dataset sourceDataset, GeoLine geoLineIn, GeoLine geoLineOut, int lineWidth, int boundWidth) {
        long l;
        long l2;
        ConversionAnalyst.a();
        if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (sourceDataset.getType() != DatasetType.IMAGE && sourceDataset.getType() != DatasetType.GRID) {
            String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentTypeInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoLineIn == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)geoLineIn) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("geoLineIn", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (geoLineOut == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)geoLineOut) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("geoLineOut", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (lineWidth < 1) {
            String string = InternalResourceSpatialanalyst.loadString("lineWidth", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (boundWidth < 1) {
            String string = InternalResourceSpatialanalyst.loadString("boundWidth", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        GeoRegion geoRegion = null;
        long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
        long l4 = ConversionAnalystNative.jni_ExtractRegion(l3, l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)geoLineIn), l = InternalHandleSpatialanalyst.getHandle((InternalHandle)geoLineOut), lineWidth, boundWidth);
        if (l4 != 0L) {
            geoRegion = (GeoRegion)InternalGeometrySpatialanalyst.createInstance(l4);
        }
        return geoRegion;
    }

    public static Dataset thinRaster(Dataset sourceDataset, long backOrNoValue, double backOrNoDataTolerance, Datasource targetDatasource, String targetDatasetName) {
        return ConversionAnalyst.thinRaster(sourceDataset, backOrNoValue, backOrNoDataTolerance, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dataset thinRaster(Dataset sourceDataset, long backOrNoValue, double backOrNoDataTolerance, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            DatasetType datasetType;
            SteppedHelper.addListeners((SteppedListener[])listeners);
            ConversionAnalyst.a();
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (sourceDataset.getType() != DatasetType.IMAGE && sourceDataset.getType() != DatasetType.GRID) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentTypeInvalid", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : sourceDataset.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            boolean bl = false;
            if (null != c) {
                bl = c.isShowProgress();
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            long l3 = ConversionAnalystNative.jni_ThinRaster(l2, backOrNoValue, backOrNoDataTolerance, l, targetDatasetName, bl);
            DatasetType datasetType2 = null;
            if (l3 != 0L) {
                datasetType = sourceDataset.getType();
                if (datasetType == DatasetType.GRID) {
                    datasetType2 = InternalDatasetGrid.createInstance(l3, targetDatasource);
                } else if (datasetType == DatasetType.IMAGE) {
                    datasetType2 = InternalDatasetImage.createInstance(l3, targetDatasource);
                } else {
                    Dataset dataset = null;
                    return dataset;
                }
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetType2);
            }
            datasetType = datasetType2;
            return datasetType;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static Dataset thinRaster(Dataset sourceDataset, Datasource targetDatasource, String targetDatasetName, long backOrNoValue, boolean isSaveAsGrid) {
        return ConversionAnalyst.thinRaster(sourceDataset, targetDatasource, targetDatasetName, backOrNoValue, isSaveAsGrid, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dataset thinRaster(Dataset sourceDataset, Datasource targetDatasource, String targetDatasetName, long backOrNoValue, boolean isSaveAsGrid, SteppedListener ... listeners) {
        try {
            DatasetType datasetType;
            SteppedHelper.addListeners((SteppedListener[])listeners);
            ConversionAnalyst.a();
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (sourceDataset.getType() != DatasetType.IMAGE && sourceDataset.getType() != DatasetType.GRID) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentTypeInvalid", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : sourceDataset.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            long l3 = ConversionAnalystNative.jni_ThinRasterBinary(l2, l, targetDatasetName, backOrNoValue, isSaveAsGrid);
            Object object = null;
            if (l3 != 0L) {
                datasetType = sourceDataset.getType();
                if (datasetType == DatasetType.GRID) {
                    object = InternalDatasetGrid.createInstance(l3, targetDatasource);
                } else if (datasetType == DatasetType.IMAGE) {
                    object = isSaveAsGrid ? InternalDatasetGrid.createInstance(l3, targetDatasource) : InternalDatasetImage.createInstance(l3, targetDatasource);
                } else {
                    Dataset dataset = null;
                    return dataset;
                }
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)object);
            }
            datasetType = object;
            return datasetType;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static GeoRegion3D rasterBoundaryRegion(Dataset sourceDataset) {
        if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ConversionAnalystNative.jni_RasterBoundaryRegion3D(InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset));
        GeoRegion3D geoRegion3D = null;
        if (l != 0L) {
            geoRegion3D = (GeoRegion3D)InternalGeometrySpatialanalyst.createInstance(l);
        }
        return geoRegion3D;
    }

    public static GeoLine3D rasterBoundaryLine(Dataset sourceDataset) {
        if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ConversionAnalystNative.jni_RasterBoundaryLine3D(InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset));
        GeoLine3D geoLine3D = null;
        if (l != 0L) {
            geoLine3D = (GeoLine3D)InternalGeometrySpatialanalyst.createInstance(l);
        }
        return geoLine3D;
    }

    public static DatasetVolume point3DToRaster(ConversionAnalystParameter parameter, int sliceCount, double startHeight, double sliceHeight) {
        return ConversionAnalyst.point3DToRaster(parameter, sliceCount, startHeight, sliceHeight, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetVolume point3DToRaster(ConversionAnalystParameter parameter, int sliceCount, double startHeight, double sliceHeight, SteppedListener ... listeners) {
        try {
            String string;
            SteppedHelper.addListeners((SteppedListener[])listeners);
            ConversionAnalyst.a();
            if (parameter == null) {
                String string2 = InternalResourceSpatialanalyst.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string2);
            }
            Dataset dataset = parameter.getSourceDataset();
            if (dataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)dataset) == 0L) {
                String string3 = InternalResourceSpatialanalyst.loadString("srcDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string3);
            }
            if (dataset.getType() != DatasetType.POINT3D) {
                String string4 = InternalResourceSpatialanalyst.loadString("srcDataset DatasetType", "GlobalUnsportedType", "spatialanalyst_resources");
                throw new NullPointerException(string4);
            }
            if (sliceCount < 1) {
                String string5 = InternalResourceSpatialanalyst.loadString("sliceCount", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string5);
            }
            Datasource datasource = parameter.getTargetDatasource();
            if (datasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource) == 0L) {
                datasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : dataset.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource) == 0L) {
                String string6 = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string6);
            }
            String string7 = parameter.getTargetDatasetName();
            if (null == string7) {
                String string8 = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string8);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                string7 = c.getGridOutputNamePrefix() + string7;
            }
            if (!datasource.getDatasets().isAvailableDatasetName(string7)) {
                String string9 = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string9);
            }
            double d = parameter.getCellSize();
            boolean bl = false;
            Rectangle2D rectangle2D = new Rectangle2D(0.0, 0.0, 0.0, 0.0);
            int n = BoundsType.INTERSECTION.value();
            if (null != c) {
                bl = c.isShowProgress();
                n = c.getBoundsType().value();
                rectangle2D = c.getBounds();
                if (d <= 0.0) {
                    d = c.getCellSize();
                }
            }
            if (null == (string = parameter.getValueFieldName()) || string.isEmpty()) {
                String string10 = InternalResourceSpatialanalyst.loadString("ValueFieldName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string10);
            }
            DatasetVector datasetVector = (DatasetVector)dataset;
            if (datasetVector.isAvailableFieldName(string)) {
                String string11 = InternalResourceSpatialanalyst.loadString("ValueFieldName", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string11);
            }
            FieldInfos fieldInfos = datasetVector.getFieldInfos();
            FieldType fieldType = fieldInfos.get(string).getType();
            if (fieldType != FieldType.DOUBLE && fieldType != FieldType.BYTE && fieldType != FieldType.INT16 && fieldType != FieldType.INT32 && fieldType != FieldType.INT64 && fieldType != FieldType.SINGLE) {
                String string12 = InternalResourceSpatialanalyst.loadString("ValueFieldName", "GlobalUnsportedType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string12);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)dataset);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource);
            PixelFormat pixelFormat = parameter.getPixelFormat();
            int n2 = InternalEnum.getUGCValue((Enum)pixelFormat);
            double d2 = parameter.getNoValue();
            long l3 = ConversionAnalystNative.jni_Point3DToRaster(l, string, d, n2, d2, l2, string7, sliceCount, startHeight, sliceHeight);
            DatasetVolume datasetVolume = null;
            if (l3 != 0L) {
                datasetVolume = InternalDatasetVolume.createInstance(l3, datasource);
                InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVolume);
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)parameter);
            DatasetVolume datasetVolume2 = datasetVolume;
            return datasetVolume2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    private static boolean a(String string) {
        String string2 = string;
        int n = string2.indexOf(".");
        if (n > 0) {
            string2 = string2.substring(n, string2.length() - n - 1);
        }
        if (string2.toLowerCase().startsWith("sm")) {
            if (string2.compareToIgnoreCase("SmUserID") == 0) {
                return false;
            }
            if (string2.compareToIgnoreCase("SmID") == 0 || string2.compareToIgnoreCase("SmSdriN") == 0 || string2.compareToIgnoreCase("SmSdriS") == 0 || string2.compareToIgnoreCase("SmSdriW") == 0 || string2.compareToIgnoreCase("SmSdriE") == 0 || string2.compareToIgnoreCase("SmGeometry") == 0 || string2.compareToIgnoreCase("SmX") == 0 || string2.compareToIgnoreCase("SmY") == 0 || string2.compareToIgnoreCase("SmZ") == 0 || string2.compareToIgnoreCase("SmKey") == 0 || string2.compareToIgnoreCase("SmGranule") == 0 || string2.compareToIgnoreCase("SmLength") == 0 || string2.compareToIgnoreCase("SmArea") == 0 || string2.compareToIgnoreCase("SmPerimeter") == 0 || string2.compareToIgnoreCase("SmLibTileID") == 0 || string2.compareToIgnoreCase("SmEdgeID") == 0 || string2.compareToIgnoreCase("SmFNode") == 0 || string2.compareToIgnoreCase("SmTNode") == 0 || string2.compareToIgnoreCase("SmResistanceA") == 0 || string2.compareToIgnoreCase("SmResistanceB") == 0 || string2.compareToIgnoreCase("SmTopoError") == 0 || string2.compareToIgnoreCase("SmNodeID") == 0 || string2.compareToIgnoreCase("SmGeoType") == 0 || string2.compareToIgnoreCase("SmRouteID") == 0 || string2.compareToIgnoreCase("SMMAXMEASURE") == 0 || string2.compareToIgnoreCase("SMMINMEASURE") == 0 || string2.compareToIgnoreCase("SmGeometrySize") == 0 || string2.compareToIgnoreCase("SmVertexSeq") == 0) {
                return true;
            }
        }
        return false;
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (a == null) {
            a = new Vector();
        }
        if (!a.contains(l)) {
            a.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (a != null && a.contains(l)) {
            a.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (a != null) {
            Vector vector = a;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "ConversionAnalyst";
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        SteppedHelper.fire((Collection)a, (SteppedEvent)steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a() {
        int n = -1;
        Object object = b;
        synchronized (object) {
            n = b.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        b = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

