/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DirectLayer;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.map.MapViewport;
import org.geotools.map.event.MapLayerListener;
import org.geotools.renderer.lite.AlphaCompositeVisitor;
import org.geotools.renderer.lite.DelayedBackbufferGraphic;
import org.geotools.renderer.lite.ZGroupLayer;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.logging.Logging;

class CompositingGroup {
    private static final Logger LOGGER = Logging.getLogger(CompositingGroup.class);
    private static StyleFactory STYLE_FACTORY = CommonFactoryFinder.getStyleFactory();
    Graphics2D graphics;
    MapContent mapContent;
    Composite composite;

    public static List<CompositingGroup> splitOnCompositingBase(Graphics2D graphics, Rectangle screenSize, MapContent mc) {
        ArrayList<CompositingGroup> result = new ArrayList<CompositingGroup>();
        ArrayList<Layer> layers = new ArrayList<Layer>();
        for (Layer layer : mc.layers()) {
            Style style = layer.getStyle();
            if (layer instanceof DirectLayer) {
                layers.add(new WrappingDirectLayer((DirectLayer)layer));
                continue;
            }
            if (layer instanceof ZGroupLayer) {
                ZGroupLayer zLayer = (ZGroupLayer)layer;
                if (zLayer.isCompositingBase()) {
                    CompositingGroup.addToCompositingMapContents(graphics, screenSize, result, layers);
                }
                layers.add(layer);
                continue;
            }
            List<Style> styles = CompositingGroup.splitOnCompositingBase(style);
            for (Style s : styles) {
                FeatureTypeStyle firstFts = (FeatureTypeStyle)s.featureTypeStyles().get(0);
                if (CompositingGroup.isCompositingBase(firstFts) && !layers.isEmpty()) {
                    CompositingGroup.addToCompositingMapContents(graphics, screenSize, result, layers);
                }
                if (s == style) {
                    layers.add(layer);
                    continue;
                }
                FeatureLayer clone = new FeatureLayer(layer.getFeatureSource(), s);
                clone.setQuery(layer.getQuery());
                clone.setVisible(layer.isVisible());
                clone.setSelected(layer.isSelected());
                clone.getUserData().putAll(layer.getUserData());
                layers.add(clone);
            }
        }
        if (!layers.isEmpty()) {
            CompositingGroup.addToCompositingMapContents(graphics, screenSize, result, layers);
        }
        return result;
    }

    private static void addToCompositingMapContents(Graphics2D graphics, Rectangle screenSize, List<CompositingGroup> compositingContents, List<Layer> layers) {
        Composite composite = CompositingGroup.getComposite(layers);
        CompositingGroup.addToCompositingMapContents(graphics, screenSize, compositingContents, layers, composite);
    }

    private static void addToCompositingMapContents(Graphics2D graphics, Rectangle screenSize, List<CompositingGroup> compositingContents, List<Layer> layers, Composite composite) {
        Graphics2D cmcGraphic = compositingContents.size() == 0 && !CompositingGroup.hasAlphaCompositing(layers) ? graphics : new DelayedBackbufferGraphic(graphics, screenSize);
        MapContent current = new MapContent();
        current.addLayers(layers);
        CompositingGroup cmc = new CompositingGroup(cmcGraphic, current, composite);
        compositingContents.add(cmc);
        layers.clear();
    }

    private static Composite getComposite(List<Layer> layers) {
        Layer layer = layers.get(0);
        if (layer instanceof ZGroupLayer) {
            return ((ZGroupLayer)layer).getComposite();
        }
        Style styles = layer.getStyle();
        List featureTypeStyles = styles.featureTypeStyles();
        if (featureTypeStyles.size() > 0) {
            FeatureTypeStyle firstFts = (FeatureTypeStyle)featureTypeStyles.get(0);
            Composite composite = SLDStyleFactory.getComposite(firstFts.getOptions());
            return composite;
        }
        return null;
    }

    private static boolean hasAlphaCompositing(List<Layer> layers) {
        AlphaCompositeVisitor visitor = new AlphaCompositeVisitor();
        for (Layer layer : layers) {
            Style style = layer.getStyle();
            style.accept((StyleVisitor)visitor);
            if (!visitor.alphaComposite) continue;
            return true;
        }
        return false;
    }

    private static List<Style> splitOnCompositingBase(Style style) {
        ArrayList<Style> styles = new ArrayList<Style>();
        ArrayList<FeatureTypeStyle> featureTypeStyles = new ArrayList<FeatureTypeStyle>();
        for (FeatureTypeStyle fts : style.featureTypeStyles()) {
            if (CompositingGroup.isCompositingBase(fts)) {
                CompositingGroup.addToStyles(styles, featureTypeStyles);
            }
            featureTypeStyles.add(fts);
        }
        CompositingGroup.addToStyles(styles, featureTypeStyles);
        return styles;
    }

    private static void addToStyles(List<Style> styles, List<FeatureTypeStyle> featureTypeStyles) {
        if (!featureTypeStyles.isEmpty()) {
            Style s = STYLE_FACTORY.createStyle();
            s.featureTypeStyles().addAll(featureTypeStyles);
            styles.add(s);
            featureTypeStyles.clear();
        }
    }

    static boolean isCompositingBase(FeatureTypeStyle fts) {
        return "true".equalsIgnoreCase((String)fts.getOptions().get("composite-base"));
    }

    CompositingGroup(Graphics2D graphics, MapContent mapContent, Composite composite) {
        this.graphics = graphics;
        this.mapContent = mapContent;
        this.composite = composite;
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    public MapContent getMapContent() {
        return this.mapContent;
    }

    public Composite getComposite() {
        return this.composite;
    }

    static class WrappingDirectLayer
    extends DirectLayer {
        DirectLayer delegate;

        public WrappingDirectLayer(DirectLayer delegate) {
            this.delegate = delegate;
        }

        @Override
        public void draw(Graphics2D graphics, MapContent map, MapViewport viewport) {
            this.delegate.draw(graphics, map, viewport);
        }

        @Override
        public void preDispose() {
        }

        @Override
        public void setTitle(String title) {
            this.delegate.setTitle(title);
        }

        @Override
        public boolean isSelected() {
            return this.delegate.isSelected();
        }

        @Override
        public ReferencedEnvelope getBounds() {
            return this.delegate.getBounds();
        }

        @Override
        public void addMapLayerListener(MapLayerListener listener) {
            this.delegate.addMapLayerListener(listener);
        }

        public boolean equals(Object arg0) {
            return this.delegate.equals(arg0);
        }

        @Override
        public String getTitle() {
            return this.delegate.getTitle();
        }

        @Override
        public boolean isVisible() {
            return this.delegate.isVisible();
        }

        @Override
        public void setVisible(boolean visible) {
            this.delegate.setVisible(visible);
        }

        @Override
        public void setSelected(boolean selected) {
            this.delegate.setSelected(selected);
        }

        @Override
        public Map<String, Object> getUserData() {
            return this.delegate.getUserData();
        }

        @Override
        public void removeMapLayerListener(MapLayerListener listener) {
            this.delegate.removeMapLayerListener(listener);
        }

        @Override
        public Style getStyle() {
            return this.delegate.getStyle();
        }

        @Override
        public FeatureSource<?, ?> getFeatureSource() {
            return this.delegate.getFeatureSource();
        }

        @Override
        public Query getQuery() {
            return this.delegate.getQuery();
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }
    }
}

