/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.HashMap;
import java.util.Map;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.ContrastMethodStrategy;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.style.ContrastMethod;

public abstract class AbstractContrastMethodStrategy
implements ContrastMethodStrategy {
    public static final String ALGORITHM = "algorithm";
    protected FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory2();
    protected ContrastMethod method = ContrastMethod.NONE;
    private Map<String, Expression> options = new HashMap<String, Expression>();

    public void setOptions(Map<String, Expression> options) {
        this.options = options;
    }

    public Expression getAlgorithm() {
        return this.options.get(ALGORITHM);
    }

    public Map<String, Expression> getParameters() {
        HashMap<String, Expression> parameters = new HashMap<String, Expression>(this.getOptions());
        if (parameters.containsKey(ALGORITHM)) {
            parameters.remove(ALGORITHM);
        }
        return parameters;
    }

    public String name() {
        return this.method.name();
    }

    public FilterFactory getFilterFactory() {
        return this.filterFactory;
    }

    public void addParameter(String key, Expression value) {
        this.addOption(key, value);
    }

    public void setAlgorithm(Expression name) {
        this.addOption(ALGORITHM, name);
    }

    public Map<String, Expression> getOptions() {
        return this.options;
    }

    public ContrastMethod getMethod() {
        return this.method;
    }

    public void addOption(String key, Expression value) {
        this.options.put(key, value);
    }

    public void setMethod(ContrastMethod method) {
        this.method = method;
    }
}

