/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.InternalHandle;
import com.supermap.data.conversion.IgnoreMode;
import com.supermap.data.conversion.ImportSetting;
import com.supermap.data.conversion.ImportSettingPNGNative;
import com.supermap.data.conversion.InternalEnum;
import com.supermap.data.conversion.InternalHandleDisposable;
import com.supermap.data.conversion.InternalResource;
import com.supermap.data.conversion.MultiBandImportMode;
import com.supermap.data.conversion.a;

public class ImportSettingPNG
extends ImportSetting {
    public ImportSettingPNG() {
        long l = ImportSettingPNGNative.jni_New();
        this.setHandle(l, true);
        super.a(com.supermap.data.conversion.a.b);
    }

    public ImportSettingPNG(ImportSettingPNG importSettingPNG) {
        if (importSettingPNG == null) {
            String string = InternalResource.loadString("importSettingPNG", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)importSettingPNG);
        if (l == 0L) {
            String string = InternalResource.loadString("importSettingPNG", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ImportSettingPNGNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.setTargetDatasourceConnectionInfo(importSettingPNG.getTargetDatasourceConnectionInfo());
        this.setTargetDatasource(importSettingPNG.getTargetDatasource());
        this.setTargetPrjCoordSys(importSettingPNG.getTargetPrjCoordSys());
        super.a(com.supermap.data.conversion.a.b);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)importSettingPNG));
    }

    public ImportSettingPNG(String sourceFilePath, DatasourceConnectionInfo targetConnectionInfo) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasourceConnectionInfo(targetConnectionInfo);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)targetConnectionInfo);
    }

    public ImportSettingPNG(String sourceFilePath, Datasource targetDatasource) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasource(targetDatasource);
    }

    public boolean isImportingAsGrid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetDataInfos()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return ImportSettingPNGNative.jni_IsImportingAsGrid(this.getHandle());
    }

    public void setImportingAsGrid(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingAsGrid(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        ImportSettingPNGNative.jni_SetImportingAsGrid(this.getHandle(), value);
    }

    public boolean isPyramidBuilt() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isPyramidBuilt()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return ImportSettingPNGNative.jni_IsPyramidBuilt(this.getHandle());
    }

    public void setPyramidBuilt(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPyramidBuilt(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        ImportSettingPNGNative.jni_SetPyramidBuilt(this.getHandle(), value);
    }

    public String getWorldFilePath() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWorldFilePath()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return ImportSettingPNGNative.jni_GetWorldFilePath(this.getHandle());
    }

    public MultiBandImportMode getMultiBandImportMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMultiBandImportMode()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingPNGNative.jni_GetMultiBandImportMode(this.getHandle());
        return (MultiBandImportMode)InternalEnum.parseUGCValue(MultiBandImportMode.class, n);
    }

    public void setMultiBandImportMode(MultiBandImportMode mode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMultiBandImportMode(MultiBandImportMode mode)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (mode == null) {
            String string = InternalResource.loadString("mode", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        if (mode != MultiBandImportMode.COMPOSITE && !this.k()) {
            String string = InternalResource.loadString("MultiBandImportMode Mode", "OnlySupportCOMPOSITEByNotHasFME", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingPNGNative.jni_SetMultiBandImportMode(this.getHandle(), mode.value());
    }

    public void setWorldFilePath(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setWorldFilePath(String value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        ImportSettingPNGNative.jni_SetWorldFilePath(this.getHandle(), value);
    }

    public void setIgnoreMode(IgnoreMode ignoreMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIgnoreMode(int ignoreMode)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ignoreMode.value();
        ImportSettingPNGNative.jni_SetIgnorMode(this.getHandle(), n);
    }

    public IgnoreMode getIgnoreMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIgnoreMode()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingPNGNative.jni_GetIgnorMode(this.getHandle());
        return (IgnoreMode)InternalEnum.parseUGCValue(IgnoreMode.class, n);
    }

    public double[] getIgnoreValues() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIgnoreValues()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingPNGNative.jni_GetIgnoreValueCount(this.getHandle());
        double[] dArray = new double[n];
        ImportSettingPNGNative.jni_GetIgnoreValues(this.getHandle(), dArray);
        return dArray;
    }

    public void setIgnoreValues(double[] ignoreValues) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIgnoreValues", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (ignoreValues == null) {
            ignoreValues = new double[]{};
        }
        ImportSettingPNGNative.jni_SetIgnoreValues(this.getHandle(), ignoreValues);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingPNGNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }
}

