/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.InternalHandle;
import com.supermap.data.conversion.IgnoreMode;
import com.supermap.data.conversion.ImportSetting;
import com.supermap.data.conversion.ImportSettingECWNative;
import com.supermap.data.conversion.InternalEnum;
import com.supermap.data.conversion.InternalHandleDisposable;
import com.supermap.data.conversion.InternalResource;
import com.supermap.data.conversion.MultiBandImportMode;
import com.supermap.data.conversion.a;

public class ImportSettingECW
extends ImportSetting {
    public ImportSettingECW() {
        long l = ImportSettingECWNative.jni_New();
        this.setHandle(l, true);
        this.setMultiBandImportMode(MultiBandImportMode.MULTIBAND);
        super.a(com.supermap.data.conversion.a.b);
    }

    public ImportSettingECW(ImportSettingECW importSettingECW) {
        if (importSettingECW == null) {
            String string = InternalResource.loadString("importSettingECW", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)importSettingECW);
        if (l == 0L) {
            String string = InternalResource.loadString("importSettingECW", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ImportSettingECWNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.setTargetDatasourceConnectionInfo(importSettingECW.getTargetDatasourceConnectionInfo());
        this.setTargetDatasource(importSettingECW.getTargetDatasource());
        this.setTargetPrjCoordSys(importSettingECW.getTargetPrjCoordSys());
        super.a(com.supermap.data.conversion.a.b);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)importSettingECW));
    }

    public ImportSettingECW(String sourceFilePath, DatasourceConnectionInfo targetConnectionInfo) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasourceConnectionInfo(targetConnectionInfo);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)targetConnectionInfo);
    }

    public ImportSettingECW(String sourceFilePath, Datasource targetDatasource) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasource(targetDatasource);
    }

    public boolean isImportingAsGrid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetDataInfos()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return ImportSettingECWNative.jni_IsImportingAsGrid(this.getHandle());
    }

    public void setImportingAsGrid(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingAsGrid(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        ImportSettingECWNative.jni_SetImportingAsGrid(this.getHandle(), value);
    }

    public MultiBandImportMode getMultiBandImportMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMultiBandImportMode()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingECWNative.jni_GetMultiBandImportMode(this.getHandle());
        return (MultiBandImportMode)InternalEnum.parseUGCValue(MultiBandImportMode.class, n);
    }

    public void setMultiBandImportMode(MultiBandImportMode mode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMultiBandImportMode(MultiBandImportMode mode)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (mode == null) {
            String string = InternalResource.loadString("mode", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingECWNative.jni_SetMultiBandImportMode(this.getHandle(), mode.value());
    }

    public void setIgnoreMode(IgnoreMode ignoreMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIgnoreMode(int ignoreMode)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ignoreMode.value();
        ImportSettingECWNative.jni_SetIgnorMode(this.getHandle(), n);
    }

    public IgnoreMode getIgnoreMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIgnoreMode()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingECWNative.jni_GetIgnorMode(this.getHandle());
        return (IgnoreMode)InternalEnum.parseUGCValue(IgnoreMode.class, n);
    }

    public double[] getIgnoreValues() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIgnoreValues()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingECWNative.jni_GetIgnoreValueCount(this.getHandle());
        double[] dArray = new double[n];
        ImportSettingECWNative.jni_GetIgnoreValues(this.getHandle(), dArray);
        return dArray;
    }

    public void setIgnoreValues(double[] ignoreValues) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIgnoreValues", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (ignoreValues == null) {
            ignoreValues = new double[]{};
        }
        ImportSettingECWNative.jni_SetIgnoreValues(this.getHandle(), ignoreValues);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingECWNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }
}

