/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.InternalHandle;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Point3D;
import com.supermap.data.conversion.CADRasterImageSettingNative;
import com.supermap.data.conversion.InternalHandleDisposable;
import com.supermap.data.conversion.InternalResource;

public class CADRasterImageSetting
extends InternalHandleDisposable {
    public CADRasterImageSetting() {
        long l = CADRasterImageSettingNative.jni_New();
        this.setHandle(l, true);
    }

    public CADRasterImageSetting(CADRasterImageSetting rasterImageSetting) {
        if (rasterImageSetting == null) {
            String string = InternalResource.loadString("CADRasterImageSetting", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)rasterImageSetting);
        if (l == 0L) {
            String string = InternalResource.loadString("CADRasterImageSetting", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = CADRasterImageSettingNative.jni_Clone(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)rasterImageSetting));
    }

    public String getSavePath() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSavePath()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return CADRasterImageSettingNative.jni_GetSavePath(this.getHandle());
    }

    public void setSavePath(String savePath) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSavePath(String savePath)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        CADRasterImageSettingNative.jni_SetSavePath(this.getHandle(), savePath);
    }

    public Point3D getOrientation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOrientation()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        CADRasterImageSettingNative.jni_GetOrientation(this.getHandle(), dArray);
        Point3D point3D = new Point3D(dArray[0], dArray[1], dArray[2]);
        return point3D;
    }

    public void setOrientation(Point3D orientation) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOrientation(Point3D orientation)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        double d = orientation.getX();
        double d2 = orientation.getY();
        double d3 = orientation.getZ();
        CADRasterImageSettingNative.jni_SetOrientation(this.getHandle(), d, d2, d3);
    }

    public double getRotationAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRotationAngle()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return CADRasterImageSettingNative.jni_GetRotationAngle(this.getHandle());
    }

    public void setRotationAngle(double rotationAngle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRotationAngle(double rotationAngle)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        CADRasterImageSettingNative.jni_SetRotationAngle(this.getHandle(), rotationAngle);
    }

    public int getPixelWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPixelWidth()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return CADRasterImageSettingNative.jni_GetPixelWidth(this.getHandle());
    }

    public void setPixelWidth(int pixelWidth) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPixelWidth(int pixelWidth)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        CADRasterImageSettingNative.jni_SetPixelWidth(this.getHandle(), pixelWidth);
    }

    public int getPixelHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPixelHeight()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return CADRasterImageSettingNative.jni_GetPixelHeight(this.getHandle());
    }

    public void setPixelHeight(int pixelHeight) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPixelHeight(int pixelHeight)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        CADRasterImageSettingNative.jni_SetPixelHeight(this.getHandle(), pixelHeight);
    }

    public double getWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWidth()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return CADRasterImageSettingNative.jni_GetWidth(this.getHandle());
    }

    public void setWidth(double width) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setWidth(double width)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        CADRasterImageSettingNative.jni_SetWidth(this.getHandle(), width);
    }

    public double getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHeight()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return CADRasterImageSettingNative.jni_GetHeight(this.getHandle());
    }

    public void setHeight(double height) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHeight(double height)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        CADRasterImageSettingNative.jni_SetHeight(this.getHandle(), height);
    }

    public int getBrightness() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBrightness()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return CADRasterImageSettingNative.jni_GetBrightness(this.getHandle());
    }

    public void setBrightness(int brightness) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBrightness(int brightness)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        CADRasterImageSettingNative.jni_SetBrightness(this.getHandle(), brightness);
    }

    public int getContrast() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getContrast()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return CADRasterImageSettingNative.jni_GetContrast(this.getHandle());
    }

    public void setContrast(int contrast) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setContrast(int contrast)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        CADRasterImageSettingNative.jni_SetContrast(this.getHandle(), contrast);
    }

    public int getFade() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFade()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return CADRasterImageSettingNative.jni_GetFade(this.getHandle());
    }

    public void setFade(int fade) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFade(int fade)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        CADRasterImageSettingNative.jni_SetFade(this.getHandle(), fade);
    }

    public Point2Ds getClipBoundary() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getClipBoundary()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = CADRasterImageSettingNative.jni_GetBoundaryPointCount(this.getHandle());
        if (n > 0) {
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            CADRasterImageSettingNative.jni_GetClipBoundary(this.getHandle(), dArray, dArray2);
            Point2Ds point2Ds = new Point2Ds();
            for (int i = 0; i < n; ++i) {
                Point2D point2D = new Point2D(dArray[i], dArray2[i]);
                point2Ds.add(point2D);
            }
            return point2Ds;
        }
        return null;
    }

    public void setClipBoundary(Point2Ds point2Ds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setClipBoundary(Point2Ds point2Ds)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = point2Ds.getCount();
        if (n > 0) {
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = point2Ds.getItem(i).getX();
                dArray2[i] = point2Ds.getItem(i).getY();
            }
            CADRasterImageSettingNative.jni_SetClipBoundary(this.getHandle(), dArray, dArray2);
        }
    }

    public boolean getIsPixelClip() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsPixelClip()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return CADRasterImageSettingNative.jni_GetIsPixelClip(this.getHandle());
    }

    public void setIsPixelClip(boolean isPixelClip) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsPixelClip(boolean isPixelClip)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        CADRasterImageSettingNative.jni_SetIsPixelClip(this.getHandle(), isPixelClip);
    }

    public boolean getIsTransparent() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsTransparent()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return CADRasterImageSettingNative.jni_GetIsTransparent(this.getHandle());
    }

    public void setIsTransparent(boolean isTransparent) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsTransparent(boolean isTransparent)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        CADRasterImageSettingNative.jni_SetIsTransparent(this.getHandle(), isTransparent);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            CADRasterImageSettingNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }
}

