/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import com.supermap.analyst.spatialanalyst.TopologicalSchema;
import com.supermap.analyst.spatialanalyst.TopologicalSchemaOrientation;
import com.supermap.analyst.spatialanalyst.TopologicalTreeSchemaNative;

public class TopologicalTreeSchema
extends TopologicalSchema {
    public TopologicalTreeSchema() {
        long l = TopologicalTreeSchemaNative.jni_NewHandle();
        this.setHandle(l, true);
    }

    public double getLevelSpacing() {
        long l = this.getHandle();
        if (l == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getLevelSpacing()", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return TopologicalTreeSchemaNative.jni_GetLevelSpacing(l);
    }

    public void setLevelSpacing(double value) {
        long l = this.getHandle();
        if (l == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("setLevelSpacing()", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResourceSpatialanalyst.loadString("value", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        TopologicalTreeSchemaNative.jni_SetLevelSpacing(l, value);
    }

    public double getNodeSpacing() {
        long l = this.getHandle();
        if (l == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getNodeSpacing()", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return TopologicalTreeSchemaNative.jni_GetNodeSpacing(l);
    }

    public void setNodeSpacing(double value) {
        long l = this.getHandle();
        if (l == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("setNodeSpacing()", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResourceSpatialanalyst.loadString("value", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        TopologicalTreeSchemaNative.jni_SetNodeSpacing(l, value);
    }

    public double getBreakRadio() {
        long l = this.getHandle();
        if (l == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getBreakRadio()", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return TopologicalTreeSchemaNative.jni_GetBreakRadio(l);
    }

    public void setBreakRadio(double value) {
        long l = this.getHandle();
        if (l == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("setBreakRadio()", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0 || value > 1.0) {
            String string = InternalResourceSpatialanalyst.loadString("value", "ShouldBetweenZeroAndOne", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        TopologicalTreeSchemaNative.jni_SetBreakRadio(l, value);
    }

    public TopologicalSchemaOrientation getOrientation() {
        long l = this.getHandle();
        if (l == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getOrientation()", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        int n = TopologicalTreeSchemaNative.jni_GetOrientation(l);
        switch (n) {
            case 0: {
                return TopologicalSchemaOrientation.LEFTTORIGHT;
            }
            case 1: {
                return TopologicalSchemaOrientation.RIGHTTOLEFT;
            }
            case 2: {
                return TopologicalSchemaOrientation.TOPTOBOTTOM;
            }
            case 3: {
                return TopologicalSchemaOrientation.BOTTOMTOTOP;
            }
        }
        return TopologicalSchemaOrientation.LEFTTORIGHT;
    }

    public void setOrientation(TopologicalSchemaOrientation value) {
        long l = this.getHandle();
        if (l == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("setOrientation()", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        TopologicalTreeSchemaNative.jni_SetOrientation(l, value.value());
    }
}

