/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import com.supermap.analyst.spatialanalyst.SmoothMethod;
import java.util.Arrays;

public class SurfaceExtractParameter {
    private double a = 0.0;
    private double b = 0.0;
    private int c = 0;
    private SmoothMethod d = SmoothMethod.NONE;
    private double e = 0.0;
    private double[] f = null;

    public SurfaceExtractParameter() {
    }

    public SurfaceExtractParameter(double interval, double datumValue) {
        this();
        this.a = interval;
        this.b = datumValue;
    }

    public SurfaceExtractParameter(double[] expectedZValues) {
        this();
        this.f = expectedZValues;
    }

    public double getDatumValue() {
        return this.b;
    }

    public double getInterval() {
        return this.a;
    }

    public double getResampleTolerance() {
        return this.e;
    }

    public SmoothMethod getSmoothMethod() {
        return this.d;
    }

    public int getSmoothness() {
        return this.c;
    }

    public double[] getExpectedZValues() {
        return this.f;
    }

    public void setDatumValue(double value) {
        this.b = value;
    }

    public void setInterval(double value) {
        this.a = value;
    }

    public void setResampleTolerance(double value) {
        this.e = value;
    }

    public void setSmoothMethod(SmoothMethod smoothMothod) {
        this.d = smoothMothod;
    }

    public void setSmoothness(int value) {
        if (value < 0 || value > 5) {
            String string = InternalResourceSpatialanalyst.loadString("smoothness", "SurfaceExtractParameter_BetweenZeroAndFive", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.c = value;
    }

    public void setExpectedZValues(double[] values) {
        this.f = values;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{DatumValue=");
        stringBuffer.append(this.getDatumValue());
        stringBuffer.append(",Interval=");
        stringBuffer.append(this.getInterval());
        stringBuffer.append(",SmoothMethod=");
        stringBuffer.append(this.getSmoothMethod().name());
        stringBuffer.append(",Smoothness=");
        stringBuffer.append(this.getSmoothness());
        stringBuffer.append(",ResampleTolerance=");
        stringBuffer.append(this.getResampleTolerance());
        stringBuffer.append(",ExpectedZValues=");
        stringBuffer.append(Arrays.toString(this.getExpectedZValues()));
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

