/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.CalculationTerrainNative;
import com.supermap.analyst.spatialanalyst.CutFillResult;
import com.supermap.analyst.spatialanalyst.ExtremumInfo;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasetImage;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalGeometrySpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalHandleSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.ProfileResult;
import com.supermap.analyst.spatialanalyst.ShadowMode;
import com.supermap.analyst.spatialanalyst.SlopeType;
import com.supermap.analyst.spatialanalyst.TerrainAnalystSetting;
import com.supermap.data.ColorDictionary;
import com.supermap.data.Colors;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetImage;
import com.supermap.data.Datasource;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoLine3D;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeoRegion3D;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedHelper;
import com.supermap.data.SteppedListener;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

public class CalculationTerrain {
    private static License a;
    private static transient Vector b;
    private static TerrainAnalystSetting c;

    private CalculationTerrain() {
        c = null;
    }

    public static TerrainAnalystSetting getAnalystSetting() {
        return c;
    }

    public static void setAnalystSetting(TerrainAnalystSetting terrainAnalystSetting) {
        if (terrainAnalystSetting == null) {
            c = null;
            return;
        }
        if (c == null) {
            c = new TerrainAnalystSetting();
        }
        c.setBounds(terrainAnalystSetting.getBounds());
        c.setBoundsType(terrainAnalystSetting.getBoundsType());
        c.setCellSizeType(terrainAnalystSetting.getCellSizeType());
        c.setCellSize(terrainAnalystSetting.getCellSize());
        c.setOutputDatasource(terrainAnalystSetting.getOutputDatasource());
        c.setGridOutputNamePrefix(terrainAnalystSetting.getGridOutputNamePrefix());
        c.setVectorOutputNamePrefix(terrainAnalystSetting.getVectorOutputNamePrefix());
        c.setValidRegion(terrainAnalystSetting.getValidRegion());
        c.setShowProgress(terrainAnalystSetting.isShowProgress());
    }

    public static DatasetGrid calculateSlope(DatasetGrid sourceDatasetGrid, SlopeType slopeType, double zFactor, Datasource targetDatasource, String targetDatasetName) {
        return CalculationTerrain.calculateSlope(sourceDatasetGrid, slopeType, zFactor, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid calculateSlope(DatasetGrid sourceDatasetGrid, SlopeType slopeType, double zFactor, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            CalculationTerrain.a();
            if (sourceDatasetGrid == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : sourceDatasetGrid.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            boolean bl = true;
            if (null != c) {
                bl = c.isShowProgress();
            }
            if (listeners == null || listeners.length == 0) {
                bl = false;
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            int n = InternalEnum.getUGCValue(slopeType);
            long l3 = CalculationTerrainNative.jni_CalculateSlope(l, n, zFactor, l2, targetDatasetName, bl);
            DatasetGrid datasetGrid = null;
            if (l3 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l3, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetGrid calculateAspect(DatasetGrid sourceDatasetGrid, Datasource targetDatasource, String targetDatasetName) {
        return CalculationTerrain.calculateAspect(sourceDatasetGrid, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid calculateAspect(DatasetGrid sourceDatasetGrid, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            CalculationTerrain.a();
            if (sourceDatasetGrid == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : sourceDatasetGrid.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            boolean bl = true;
            if (null != c) {
                bl = c.isShowProgress();
            }
            if (listeners == null || listeners.length == 0) {
                bl = false;
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l3 = CalculationTerrainNative.jni_CalculateAspect(l, l2, targetDatasetName, bl);
            DatasetGrid datasetGrid = null;
            if (l3 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l3, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetGrid calculateHillShade(DatasetGrid sourceDatasetGrid, ShadowMode shadowMode, double azimuth, double altitudeAngle, double zFactor, Datasource targetDatasource, String targetDatasetName) {
        return CalculationTerrain.calculateHillShade(sourceDatasetGrid, shadowMode, azimuth, altitudeAngle, zFactor, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid calculateHillShade(DatasetGrid sourceDatasetGrid, ShadowMode shadowMode, double azimuth, double altitudeAngle, double zFactor, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            CalculationTerrain.a();
            if (sourceDatasetGrid == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : sourceDatasetGrid.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (altitudeAngle > 90.0 || altitudeAngle < 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("altitude", "Value Should_Between_0_And_90", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            boolean bl = true;
            if (null != c) {
                bl = c.isShowProgress();
            }
            if (listeners == null || listeners.length == 0) {
                bl = false;
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            int n = InternalEnum.getUGCValue(shadowMode);
            long l3 = CalculationTerrainNative.jni_CalculateHillShade(l, n, azimuth, altitudeAngle, zFactor, l2, targetDatasetName, bl);
            DatasetGrid datasetGrid = null;
            if (l3 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l3, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    @Deprecated
    public static DatasetImage calculateOrthoImage(DatasetGrid sourceDatasetGrid, Colors colors, double zFactor, Datasource targetDatasource, String targetDatasetName) {
        CalculationTerrain.a();
        Datasource datasource = targetDatasource;
        String string = targetDatasetName;
        if (sourceDatasetGrid == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid) == 0L) {
            String string2 = InternalResourceSpatialanalyst.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
            if (c == null || c.getOutputDatasource() == null) {
                String string3 = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string3);
            }
            datasource = c.getOutputDatasource();
        }
        if (string == null) {
            String string4 = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (c != null && c.getGridOutputNamePrefix() != null) {
            string = c.getGridOutputNamePrefix() + string;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid);
        long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)colors);
        long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource);
        long l4 = CalculationTerrainNative.jni_CalculateOrthoImage(l, l2, 0L, l3, string, false);
        DatasetImage datasetImage = null;
        if (l4 != 0L) {
            datasetImage = InternalDatasetImage.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetImage);
        }
        return datasetImage;
    }

    @Deprecated
    public static DatasetImage calculateOrthoImage(DatasetGrid sourceDatasetGrid, Colors colors, Color noValueColor, double zFactor, Datasource targetDatasource, String targetDatasetName) {
        return CalculationTerrain.calculateOrthoImage(sourceDatasetGrid, colors, noValueColor, targetDatasource, targetDatasetName);
    }

    public static DatasetImage calculateOrthoImage(DatasetGrid sourceDatasetGrid, Colors colors, Color noValueColor, Datasource targetDatasource, String targetDatasetName) {
        return CalculationTerrain.calculateOrthoImage(sourceDatasetGrid, colors, noValueColor, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetImage calculateOrthoImage(DatasetGrid sourceDatasetGrid, Colors colors, Color noValueColor, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            CalculationTerrain.a();
            if (sourceDatasetGrid == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : sourceDatasetGrid.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            boolean bl = true;
            if (null != c) {
                bl = c.isShowProgress();
            }
            if (listeners == null || listeners.length == 0) {
                bl = false;
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)colors);
            Colors colors2 = new Colors();
            colors2.add(noValueColor);
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)colors2);
            long l4 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l5 = CalculationTerrainNative.jni_CalculateOrthoImage(l, l2, l3, l4, targetDatasetName, bl);
            DatasetImage datasetImage = null;
            if (l5 != 0L) {
                datasetImage = InternalDatasetImage.createInstance(l5, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetImage);
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)colors);
            InternalHandleDisposable.makeSureNativeObjectLive((Object)colors2);
            DatasetImage datasetImage2 = datasetImage;
            return datasetImage2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetImage calculateOrthoImage(DatasetGrid sourceDatasetGrid, ColorDictionary colorDictionary, Color noValueColor, Datasource targetDatasource, String targetDatasetName) {
        return CalculationTerrain.calculateOrthoImage(sourceDatasetGrid, colorDictionary, noValueColor, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetImage calculateOrthoImage(DatasetGrid sourceDatasetGrid, ColorDictionary colorDictionary, Color noValueColor, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            CalculationTerrain.a();
            if (sourceDatasetGrid == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : sourceDatasetGrid.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            boolean bl = false;
            if (null != c) {
                bl = c.isShowProgress();
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)colorDictionary);
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l4 = CalculationTerrainNative.jni_CalculateOrthoImageColorDictionary(l, l2, noValueColor.getRGB(), l3, targetDatasetName, bl);
            DatasetImage datasetImage = null;
            if (l4 != 0L) {
                datasetImage = InternalDatasetImage.createInstance(l4, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetImage);
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)colorDictionary);
            DatasetImage datasetImage2 = datasetImage;
            return datasetImage2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    @Deprecated
    public static ProfileResult calculateProfile(DatasetGrid sourceDatasetGrid, GeoLine line, double resampleTolerance) {
        return CalculationTerrain.calculateProfile(sourceDatasetGrid, line);
    }

    public static ProfileResult calculateProfile(DatasetGrid sourceDatasetGrid, GeoLine line) {
        CalculationTerrain.a();
        if (sourceDatasetGrid == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid);
        long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)line);
        double d = 0.0;
        long[] lArray = CalculationTerrainNative.jni_CalculateProfile(l, l2, d);
        ProfileResult profileResult = null;
        if (lArray != null && lArray.length == 2) {
            Geometry geometry = null;
            geometry = InternalGeometrySpatialanalyst.createInstance(lArray[0]);
            Geometry geometry2 = null;
            geometry2 = InternalGeometrySpatialanalyst.createInstance(lArray[1]);
            profileResult = new ProfileResult((GeoLine)geometry, (GeoLine)geometry2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)line);
        return profileResult;
    }

    public static ExtremumInfo findExtremum(DatasetGrid sourceDatasetGrid, GeoRegion region, long maxCount) {
        return CalculationTerrain.findExtremum(sourceDatasetGrid, region, maxCount, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExtremumInfo findExtremum(DatasetGrid sourceDatasetGrid, GeoRegion region, long maxCount, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            CalculationTerrain.a();
            if (sourceDatasetGrid == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid);
            long l2 = 0L;
            if (region != null) {
                l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)region);
            } else if (c != null && c.getValidRegion() != null) {
                l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)c.getValidRegion());
            }
            double[] dArray = CalculationTerrainNative.jni_FindExtremum(l, l2, maxCount);
            boolean bl = false;
            if (dArray[0] == 1.0) {
                bl = true;
            }
            ExtremumInfo extremumInfo = null;
            if (bl) {
                int n;
                int n2 = (int)dArray[1];
                int n3 = (int)dArray[2];
                Point2D point2D = new Point2D();
                Point2Ds point2Ds = new Point2Ds();
                Point2Ds point2Ds2 = new Point2Ds();
                for (n = 0; n < n2; ++n) {
                    point2D.setX(dArray[5 + 2 * n]);
                    point2D.setY(dArray[5 + 2 * n + 1]);
                    point2Ds.add(point2D);
                }
                n = 5 + n2 * 2;
                for (int i = 0; i < n3; ++i) {
                    point2D.setX(dArray[n + 2 * i]);
                    point2D.setY(dArray[n + 2 * i + 1]);
                    point2Ds2.add(point2D);
                }
                extremumInfo = new ExtremumInfo(dArray[3], dArray[4], point2Ds, point2Ds2);
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)region);
            ExtremumInfo extremumInfo2 = extremumInfo;
            return extremumInfo2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static GeoRegion flood(DatasetGrid sourceDatasetGrid, double height, GeoRegion validRegion) {
        return CalculationTerrain.flood(sourceDatasetGrid, height, validRegion, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeoRegion flood(DatasetGrid sourceDatasetGrid, double height, GeoRegion validRegion, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            CalculationTerrain.a();
            if (sourceDatasetGrid == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid);
            boolean bl = false;
            if (null != c) {
                bl = c.isShowProgress();
            }
            long l2 = 0L;
            if (validRegion != null) {
                l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)validRegion);
            } else if (c != null && c.getValidRegion() != null) {
                l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)c.getValidRegion());
            }
            long l3 = CalculationTerrainNative.jni_Flood(l, height, l2, bl);
            GeoRegion geoRegion = null;
            if (l3 != 0L) {
                geoRegion = (GeoRegion)InternalGeometrySpatialanalyst.createInstance(l3);
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)validRegion);
            GeoRegion geoRegion2 = geoRegion;
            return geoRegion2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static CutFillResult cutFill(DatasetGrid beforeCutFillDataGrid, DatasetGrid afterCutFillDataGrid, Datasource targetDatasource, String targetDatasetName) {
        return CalculationTerrain.cutFill(beforeCutFillDataGrid, afterCutFillDataGrid, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CutFillResult cutFill(DatasetGrid beforeCutFillDataGrid, DatasetGrid afterCutFillDataGrid, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            DatasetGrid datasetGrid;
            SteppedHelper.addListeners((SteppedListener[])listeners);
            CalculationTerrain.a();
            if (beforeCutFillDataGrid == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)beforeCutFillDataGrid) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("preCutFillDataGrid", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (afterCutFillDataGrid == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)afterCutFillDataGrid) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("afterCutFillDataGrid", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : beforeCutFillDataGrid.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            boolean bl = true;
            if (null != c) {
                bl = c.isShowProgress();
            }
            if (listeners == null || listeners.length == 0) {
                bl = false;
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)beforeCutFillDataGrid);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)afterCutFillDataGrid);
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            double[] dArray = new double[5];
            long l4 = CalculationTerrainNative.jni_CutFill(l, l2, l3, targetDatasetName, dArray, bl);
            Object object = null;
            if (l4 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
                object = new CutFillResult(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], datasetGrid);
            }
            datasetGrid = object;
            return datasetGrid;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static CutFillResult cutFill(DatasetGrid sourceDatasetGrid, GeoRegion region, double baseAltitude, Datasource targetDatasource, String targetDatasetName) {
        return CalculationTerrain.cutFill(sourceDatasetGrid, region, baseAltitude, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    public static double cutFill(DatasetGrid sourceDatasetGrid, double volume, boolean isFill) {
        return CalculationTerrain.cutFill(sourceDatasetGrid, volume, isFill, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CutFillResult cutFill(DatasetGrid sourceDatasetGrid, GeoRegion region, double baseAltitude, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            DatasetGrid datasetGrid;
            SteppedHelper.addListeners((SteppedListener[])listeners);
            CalculationTerrain.a();
            if (sourceDatasetGrid == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : sourceDatasetGrid.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = 0L;
            if (region != null) {
                l = InternalHandleSpatialanalyst.getHandle((InternalHandle)region);
            } else if (c != null && c.getValidRegion() != null) {
                l = InternalHandleSpatialanalyst.getHandle((InternalHandle)c.getValidRegion());
            }
            boolean bl = true;
            if (null != c) {
                bl = c.isShowProgress();
            }
            if (listeners == null || listeners.length == 0) {
                bl = false;
            }
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid);
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            double[] dArray = new double[5];
            long l4 = CalculationTerrainNative.jni_CutFillSelect(l2, l, baseAltitude, l3, targetDatasetName, dArray, bl);
            CutFillResult cutFillResult = null;
            if (l4 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
                cutFillResult = new CutFillResult(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], datasetGrid);
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)region);
            datasetGrid = cutFillResult;
            return datasetGrid;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static CutFillResult cutFill(DatasetGrid sourceDatasetGrid, GeoRegion region, double baseAltitude) {
        return CalculationTerrain.cutFill(sourceDatasetGrid, region, baseAltitude, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CutFillResult cutFill(DatasetGrid sourceDatasetGrid, GeoRegion region, double baseAltitude, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            CalculationTerrain.a();
            if (sourceDatasetGrid == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            long l = 0L;
            if (region != null) {
                l = InternalHandleSpatialanalyst.getHandle((InternalHandle)region);
            } else if (c != null && c.getValidRegion() != null) {
                l = InternalHandleSpatialanalyst.getHandle((InternalHandle)c.getValidRegion());
            }
            boolean bl = false;
            if (null != c) {
                bl = c.isShowProgress();
            }
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid);
            double[] dArray = new double[5];
            boolean bl2 = CalculationTerrainNative.jni_CutFillSelectNoGridResult(l2, l, baseAltitude, dArray, bl);
            CutFillResult cutFillResult = null;
            if (bl2) {
                cutFillResult = new CutFillResult(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], null);
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)region);
            CutFillResult cutFillResult2 = cutFillResult;
            return cutFillResult2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static CutFillResult cutFill(DatasetGrid sourceDatasetGrid, GeoLine3D line3D, double bufferRadius, boolean isRoundHead, Datasource targetDatasource, String targetDatasetName) {
        return CalculationTerrain.cutFill(sourceDatasetGrid, line3D, bufferRadius, isRoundHead, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CutFillResult cutFill(DatasetGrid sourceDatasetGrid, GeoLine3D line3D, double bufferRadius, boolean isRoundHead, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            DatasetGrid datasetGrid;
            SteppedHelper.addListeners((SteppedListener[])listeners);
            CalculationTerrain.a();
            if (sourceDatasetGrid == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (line3D == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)line3D) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("line3D", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : sourceDatasetGrid.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            boolean bl = true;
            if (null != c) {
                bl = c.isShowProgress();
            }
            if (listeners == null || listeners.length == 0) {
                bl = false;
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)line3D);
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            double[] dArray = new double[5];
            long l4 = CalculationTerrainNative.jni_CutFillIncline(l, l2, bufferRadius, isRoundHead, l3, targetDatasetName, dArray, bl);
            CutFillResult cutFillResult = null;
            if (l4 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
                cutFillResult = new CutFillResult(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], datasetGrid);
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)line3D);
            datasetGrid = cutFillResult;
            return datasetGrid;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static CutFillResult cutFill(DatasetGrid sourceDatasetGrid, GeoRegion3D region3D, Datasource targetDatasource, String targetDatasetName) {
        return CalculationTerrain.cutFill(sourceDatasetGrid, region3D, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CutFillResult cutFill(DatasetGrid sourceDatasetGrid, GeoRegion3D region3D, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            DatasetGrid datasetGrid;
            SteppedHelper.addListeners((SteppedListener[])listeners);
            CalculationTerrain.a();
            if (sourceDatasetGrid == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (region3D == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)region3D) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("region3D", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : sourceDatasetGrid.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            boolean bl = false;
            if (null != c) {
                bl = c.isShowProgress();
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)region3D);
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            double[] dArray = new double[5];
            long l4 = CalculationTerrainNative.jni_CutFillRegion3D(l, l2, l3, targetDatasetName, dArray, bl);
            CutFillResult cutFillResult = null;
            if (l4 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
                cutFillResult = new CutFillResult(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], datasetGrid);
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)region3D);
            datasetGrid = cutFillResult;
            return datasetGrid;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static double cutFill(DatasetGrid sourceDatasetGrid, double volume, boolean isFill, GeoRegion region) {
        if (sourceDatasetGrid == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (volume <= 0.0) {
            String string = InternalResourceSpatialanalyst.loadString("volume", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (region != null) {
            l = InternalHandleSpatialanalyst.getHandle((InternalHandle)region);
        } else if (c != null && c.getValidRegion() != null) {
            l = InternalHandleSpatialanalyst.getHandle((InternalHandle)c.getValidRegion());
        }
        long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid);
        return CalculationTerrainNative.jni_CutFillByVolume(l2, volume, isFill, l);
    }

    public static double computeSurfaceDistance(DatasetGrid sourceDatasetGrid, GeoLine line) {
        if (sourceDatasetGrid == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (line == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)line) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("line", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid);
        long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)line);
        double d = CalculationTerrainNative.jni_ComputeSurfaceDistance(l, l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)line);
        return d;
    }

    public static double computeSurfaceArea(DatasetGrid sourceDatasetGrid, GeoRegion region) {
        if (sourceDatasetGrid == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid);
        long l2 = 0L;
        if (region != null) {
            l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)region);
        } else if (c != null && c.getValidRegion() != null) {
            l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)c.getValidRegion());
        }
        double d = CalculationTerrainNative.jni_ComputeSurfaceArea(l, l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)region);
        return d;
    }

    public static double computeSurfaceVolume(DatasetGrid sourceDatasetGrid, GeoRegion region, double baseValue) {
        CalculationTerrain.a();
        if (sourceDatasetGrid == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid);
        long l2 = 0L;
        if (region != null) {
            l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)region);
        } else if (c != null && c.getValidRegion() != null) {
            l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)c.getValidRegion());
        }
        double d = CalculationTerrainNative.jni_ComputeSurfaceVolume(l, l2, baseValue);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)region);
        return d;
    }

    public static double computePointSlope(DatasetGrid sourceDatasetGrid, Point2D specifiedPoint, SlopeType slopeType, double zFactor) {
        CalculationTerrain.a();
        if (sourceDatasetGrid == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid);
        int n = InternalEnum.getUGCValue(slopeType);
        return CalculationTerrainNative.jni_ComputePointSlope(l, specifiedPoint.getX(), specifiedPoint.getY(), n, zFactor);
    }

    public static double computePointAspect(DatasetGrid sourceDatasetGrid, Point2D specifiedPoint) {
        CalculationTerrain.a();
        if (sourceDatasetGrid == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid);
        return CalculationTerrainNative.jni_ComputePointAspect(l, specifiedPoint.getX(), specifiedPoint.getY());
    }

    public static DatasetGrid calculateCurvature(DatasetGrid sourceDatasetGrid, double zFactor, Datasource targetDatasource, String averageCurvatureName, String profileCurvatureName, String planCurvatureName) {
        return CalculationTerrain.calculateCurvature(sourceDatasetGrid, zFactor, targetDatasource, averageCurvatureName, profileCurvatureName, planCurvatureName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid calculateCurvature(DatasetGrid sourceDatasetGrid, double zFactor, Datasource targetDatasource, String averageCurvatureName, String profileCurvatureName, String planCurvatureName, SteppedListener ... listeners) {
        try {
            DatasetGrid datasetGrid;
            SteppedHelper.addListeners((SteppedListener[])listeners);
            CalculationTerrain.a();
            if (sourceDatasetGrid == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : sourceDatasetGrid.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == averageCurvatureName) {
                String string = InternalResourceSpatialanalyst.loadString("curvatureGridName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                averageCurvatureName = c.getGridOutputNamePrefix() + averageCurvatureName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(averageCurvatureName)) {
                String string = InternalResourceSpatialanalyst.loadString("averageCurvatureName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (profileCurvatureName != null && !profileCurvatureName.isEmpty() && !targetDatasource.getDatasets().isAvailableDatasetName(profileCurvatureName)) {
                String string = InternalResourceSpatialanalyst.loadString("profileCurvatureName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (planCurvatureName != null && !planCurvatureName.isEmpty() && !targetDatasource.getDatasets().isAvailableDatasetName(planCurvatureName)) {
                String string = InternalResourceSpatialanalyst.loadString("planCurvatureName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            boolean bl = true;
            if (null != c) {
                bl = c.isShowProgress();
            }
            if (listeners == null || listeners.length == 0) {
                bl = false;
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long[] lArray = CalculationTerrainNative.jni_CalculateCurvature(l, zFactor, l2, averageCurvatureName, profileCurvatureName, planCurvatureName, bl);
            DatasetGrid datasetGrid2 = null;
            if (lArray != null && lArray.length == 3 && lArray[0] != 0L) {
                datasetGrid2 = InternalDatasetGrid.createInstance(lArray[0], targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid2);
                if (lArray[1] != 0L) {
                    datasetGrid = InternalDatasetGrid.createInstance(lArray[1], targetDatasource);
                    InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
                }
                if (lArray[2] != 0L) {
                    datasetGrid = InternalDatasetGrid.createInstance(lArray[2], targetDatasource);
                    InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
                }
            }
            datasetGrid = datasetGrid2;
            return datasetGrid;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a() {
        int n = -1;
        Object object = a;
        synchronized (object) {
            n = a.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (b == null) {
            b = new Vector();
        }
        if (!b.contains(l)) {
            b.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (b != null && b.contains(l)) {
            b.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (b != null) {
            Vector vector = b;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "CalculationTerrain";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        SteppedHelper.fire((Collection)b, (SteppedEvent)steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        a = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

