/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.ANNCellularAutomataParameter;
import com.supermap.analyst.spatialanalyst.ANNCellularAutomataResult;
import com.supermap.analyst.spatialanalyst.ANNParameter;
import com.supermap.analyst.spatialanalyst.ANNTrainIterationResult;
import com.supermap.analyst.spatialanalyst.ANNTrainResult;
import com.supermap.analyst.spatialanalyst.AnnTrainedEvent;
import com.supermap.analyst.spatialanalyst.AnnTrainedListener;
import com.supermap.analyst.spatialanalyst.ArtificialNeuralNetworkCANative;
import com.supermap.analyst.spatialanalyst.CAFlushedEvent;
import com.supermap.analyst.spatialanalyst.CAFlushedListener;
import com.supermap.analyst.spatialanalyst.CellularAutomataParameter;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalHandleSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.PrincipalComponentAnalysisCANative;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.Datasource;
import com.supermap.data.InternalHandle;
import com.supermap.data.PixelFormat;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedHelper;
import com.supermap.data.SteppedListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

public class ANNCellularAutomata
extends InternalHandleDisposable {
    private static License b;
    private static transient Vector c;
    private static transient Vector d;
    private transient Vector e;
    ANNTrainResult a;
    private boolean f;
    private boolean g;

    public ANNCellularAutomata() {
        long l = ArtificialNeuralNetworkCANative.jni_New();
        this.setHandle(l, true);
        this.f = false;
        this.g = false;
        this.a = null;
    }

    protected long getHandle() {
        long l = super.getHandle();
        if (l != 0L) {
            // empty if block
        }
        return l;
    }

    public void dispose() {
        if (super.getHandle() != 0L) {
            ArtificialNeuralNetworkCANative.jni_Delete(super.getHandle());
            this.setHandle(0L);
        }
    }

    private void a(CellularAutomataParameter cellularAutomataParameter) {
        long l = super.getHandle();
        long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)cellularAutomataParameter.getCellGrid());
        DatasetGrid[] datasetGridArray = cellularAutomataParameter.getSpatialVariableGrids();
        long[] lArray = new long[datasetGridArray.length];
        for (int i = 0; i < datasetGridArray.length; ++i) {
            lArray[i] = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasetGridArray[i]);
        }
        long l3 = 0L;
        if (cellularAutomataParameter.getOutputDataSource() != null) {
            l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)cellularAutomataParameter.getOutputDataSource());
        }
        PrincipalComponentAnalysisCANative.jni_setCellularAutomataParameter(l, l2, lArray, l3, cellularAutomataParameter.getOutputDatasetName(), cellularAutomataParameter.IsSave(), cellularAutomataParameter.getSaveFrequency(), cellularAutomataParameter.getFlushFrequency(), cellularAutomataParameter.getSimulationCount(), cellularAutomataParameter.getFlushFilePathName(), cellularAutomataParameter.getIterations());
    }

    private ANNTrainResult a() {
        return this.a;
    }

    public boolean initializeAnn(DatasetGrid trainStartCellGrid, DatasetGrid trainEndCellGrid, int[] annTrainValues, DatasetGrid[] spatialVariableGrids, ANNParameter annParameter) {
        return this.initializeAnn(trainStartCellGrid, trainEndCellGrid, annTrainValues, spatialVariableGrids, annParameter, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initializeAnn(DatasetGrid trainStartCellGrid, DatasetGrid trainEndCellGrid, int[] annTrainValues, DatasetGrid[] spatialVariableGrids, ANNParameter annParameter, SteppedListener ... listeners) {
        try {
            int n;
            ANNCellularAutomata.b();
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (null == trainStartCellGrid || 0L == InternalHandleSpatialanalyst.getHandle((InternalHandle)trainStartCellGrid)) {
                String string = InternalResourceSpatialanalyst.loadString("trainStartCellGrid", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (trainStartCellGrid.getPixelFormat() != PixelFormat.BIT8 && trainStartCellGrid.getPixelFormat() != PixelFormat.BIT16 && trainStartCellGrid.getPixelFormat() != PixelFormat.BIT32 && trainStartCellGrid.getPixelFormat() != PixelFormat.BIT64 && trainStartCellGrid.getPixelFormat() != PixelFormat.UBIT1 && trainStartCellGrid.getPixelFormat() != PixelFormat.UBIT4 && trainStartCellGrid.getPixelFormat() != PixelFormat.UBIT8 && trainStartCellGrid.getPixelFormat() != PixelFormat.UBIT16 && trainStartCellGrid.getPixelFormat() != PixelFormat.UBIT32) {
                String string = InternalResourceSpatialanalyst.loadString("trainStartCellGrid", "ZonalDataset_UnsupportedDatasetType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == trainStartCellGrid || 0L == InternalHandleSpatialanalyst.getHandle((InternalHandle)trainStartCellGrid)) {
                String string = InternalResourceSpatialanalyst.loadString("trainStartCellGrid", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (trainEndCellGrid.getPixelFormat() != PixelFormat.BIT8 && trainEndCellGrid.getPixelFormat() != PixelFormat.BIT16 && trainEndCellGrid.getPixelFormat() != PixelFormat.BIT32 && trainEndCellGrid.getPixelFormat() != PixelFormat.BIT64 && trainEndCellGrid.getPixelFormat() != PixelFormat.UBIT1 && trainEndCellGrid.getPixelFormat() != PixelFormat.UBIT4 && trainEndCellGrid.getPixelFormat() != PixelFormat.UBIT8 && trainEndCellGrid.getPixelFormat() != PixelFormat.UBIT16 && trainEndCellGrid.getPixelFormat() != PixelFormat.UBIT32) {
                String string = InternalResourceSpatialanalyst.loadString("trainEndCellGrid", "ZonalDataset_UnsupportedDatasetType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (annTrainValues == null || annTrainValues.length == 0) {
                String string = InternalResourceSpatialanalyst.loadString("annTrainValues", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (annTrainValues.length < 2) {
                String string = InternalResourceSpatialanalyst.loadString("annTrainValues", "Must_Larger_Than_One", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (spatialVariableGrids == null || spatialVariableGrids.length == 0) {
                String string = InternalResourceSpatialanalyst.loadString("spatialVariableGrids", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            for (int i = 0; i < spatialVariableGrids.length; ++i) {
                if (spatialVariableGrids[i] != null && 0L != InternalHandleSpatialanalyst.getHandle((InternalHandle)spatialVariableGrids[i])) continue;
                String string = InternalResourceSpatialanalyst.loadString("spatialVariableGrids[" + i + "]", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            this.a(annParameter);
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)trainStartCellGrid);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)trainEndCellGrid);
            long[] lArray = new long[spatialVariableGrids.length];
            for (n = 0; n < spatialVariableGrids.length; ++n) {
                lArray[n] = InternalHandleSpatialanalyst.getHandle((InternalHandle)spatialVariableGrids[n]);
            }
            n = annParameter.getNeighborhoodNumber();
            double d = annParameter.getLearningRate();
            int n2 = annParameter.getSampleCount();
            String[] stringArray = new String[1];
            boolean bl = ArtificialNeuralNetworkCANative.jni_initializationAnn(super.getHandle(), l, l2, annTrainValues, lArray, annParameter.isCustomNeighborhood(), annParameter.getCustomNeighborhoods(), n, d, n2, stringArray);
            if (!bl && stringArray[0] != null && !stringArray[0].isEmpty()) {
                throw new RuntimeException(stringArray[0]);
            }
            this.f = true;
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public ANNTrainResult annTrain(double dErrorRate, int nMaxTimes) {
        return this.annTrain(dErrorRate, nMaxTimes, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ANNTrainResult annTrain(double dErrorRate, int nMaxTimes, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (!this.f) {
                String string = InternalResourceSpatialanalyst.loadString("Please execute 'initializationAnn()' method first.", "Global_EnumValueIsError", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            this.a(dErrorRate, nMaxTimes);
            this.a = null;
            String[] stringArray = new String[1];
            double[] dArray = ArtificialNeuralNetworkCANative.jni_annTrain((Object)this, super.getHandle(), dErrorRate, nMaxTimes, stringArray);
            if (dArray != null && dArray.length > 0) {
                double d = dArray[dArray.length - 1];
                int n = (dArray.length - 1) / 2;
                if (n != 0) {
                    ArrayList<ANNTrainIterationResult> arrayList = new ArrayList<ANNTrainIterationResult>();
                    for (int i = 0; i < n; ++i) {
                        arrayList.add(new ANNTrainIterationResult((int)dArray[2 * i], dArray[2 * i + 1]));
                    }
                    this.a = new ANNTrainResult(arrayList, d, ArtificialNeuralNetworkCANative.jni_getAnnTrainValues(super.getHandle()), ArtificialNeuralNetworkCANative.jni_getAnnTrainSpatialVariableNames(super.getHandle()));
                } else {
                    this.a = new ANNTrainResult(null, d, ArtificialNeuralNetworkCANative.jni_getAnnTrainValues(super.getHandle()), ArtificialNeuralNetworkCANative.jni_getAnnTrainSpatialVariableNames(super.getHandle()));
                }
            } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
                throw new RuntimeException(stringArray[0]);
            }
            this.g = true;
            ANNTrainResult aNNTrainResult = this.a;
            return aNNTrainResult;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public ANNCellularAutomataResult annCellularAutomata(Datasource outputDatasource, String outputDatasetName, ANNCellularAutomataParameter annCAParameter) {
        return this.annCellularAutomata(outputDatasource, outputDatasetName, annCAParameter, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ANNCellularAutomataResult annCellularAutomata(Datasource outputDatasource, String outputDatasetName, ANNCellularAutomataParameter annCAParameter, SteppedListener ... listeners) {
        try {
            Object object;
            SteppedHelper.addListeners((SteppedListener[])listeners);
            this.a(annCAParameter);
            if (!this.g) {
                String string = InternalResourceSpatialanalyst.loadString("Please execute 'annTrain()' method first.", "Global_EnumValueIsError", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (null == outputDatasource || 0L == InternalHandleSpatialanalyst.getHandle((InternalHandle)outputDatasource)) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (outputDatasetName == null || outputDatasetName.trim().equalsIgnoreCase("")) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasetName", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            this.a(annCAParameter.getCellularAutomataParameter());
            long l = 0L;
            if (annCAParameter.isCheckResult()) {
                l = InternalHandleSpatialanalyst.getHandle((InternalHandle)annCAParameter.getEndCellGrid());
            }
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)outputDatasource);
            long[] lArray = new long[]{0L};
            String[] stringArray = new String[1];
            double[] dArray = ArtificialNeuralNetworkCANative.jni_annCA(super.getHandle(), l2, outputDatasetName, annCAParameter.isCheckResult(), l, annCAParameter.getThreshold(), annCAParameter.getAlpha(), annCAParameter.getConversionRules(), annCAParameter.getConversionClassIDs(), lArray, stringArray);
            Object object2 = null;
            DatasetGrid datasetGrid = null;
            if (lArray[0] != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(lArray[0], outputDatasource);
                InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetGrid);
                object = ArtificialNeuralNetworkCANative.jni_getIterationResults(super.getHandle());
                if (object != null && ((long[])object).length != 0) {
                    for (int i = 0; i < ((long[])object).length; ++i) {
                        DatasetGrid datasetGrid2 = InternalDatasetGrid.createInstance(object[i], annCAParameter.getCellularAutomataParameter().getOutputDataSource());
                        InternalDatasets.add(annCAParameter.getCellularAutomataParameter().getOutputDataSource().getDatasets(), (Dataset)datasetGrid2);
                    }
                }
            }
            if (lArray[0] != 0L) {
                if (dArray != null && dArray.length > 1) {
                    object = new ArrayList();
                    ArrayList<Double> arrayList = new ArrayList<Double>();
                    int n = dArray.length / 2;
                    for (int i = 0; i < n; ++i) {
                        ((ArrayList)object).add(dArray[i * 2]);
                        arrayList.add(dArray[i * 2 + 1]);
                    }
                    object2 = new ANNCellularAutomataResult((ArrayList<Double>)object, arrayList, datasetGrid);
                } else {
                    object2 = new ANNCellularAutomataResult(null, null, datasetGrid);
                }
            } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
                throw new RuntimeException(stringArray[0]);
            }
            object = object2;
            return object;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public boolean saveModel(String modelFile) {
        if (!this.g) {
            String string = InternalResourceSpatialanalyst.loadString("Please execute 'annTrain()' method first.", "Global_EnumValueIsError", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (modelFile == null || modelFile.trim().equalsIgnoreCase("")) {
            String string = InternalResourceSpatialanalyst.loadString("modelFile", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        File file = new File(modelFile);
        if (file.exists()) {
            String string = InternalResourceSpatialanalyst.loadString("modelFile", "Global_FileAlreadyExist", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        return ArtificialNeuralNetworkCANative.jni_saveAnnTrainModel(super.getHandle(), modelFile);
    }

    public ANNTrainResult loadModel(String modelFile) {
        if (modelFile == null || modelFile.trim().equalsIgnoreCase("")) {
            String string = InternalResourceSpatialanalyst.loadString("modelFile", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        File file = new File(modelFile);
        if (!file.exists()) {
            String string = InternalResourceSpatialanalyst.loadString("modelFile", "Global_FileNotFound", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.g = false;
        double[] dArray = ArtificialNeuralNetworkCANative.jni_loadAnnTrainModel(super.getHandle(), modelFile);
        if (dArray != null && dArray.length > 0) {
            double d = dArray[dArray.length - 1];
            int n = (dArray.length - 1) / 2;
            if (n != 0) {
                ArrayList<ANNTrainIterationResult> arrayList = new ArrayList<ANNTrainIterationResult>();
                for (int i = 0; i < n; ++i) {
                    arrayList.add(new ANNTrainIterationResult((int)dArray[2 * i], dArray[2 * i + 1]));
                }
                this.a = new ANNTrainResult(arrayList, d, ArtificialNeuralNetworkCANative.jni_getAnnTrainValues(super.getHandle()), ArtificialNeuralNetworkCANative.jni_getAnnTrainSpatialVariableNames(super.getHandle()));
            } else {
                this.a = new ANNTrainResult(null, d, ArtificialNeuralNetworkCANative.jni_getAnnTrainValues(super.getHandle()), ArtificialNeuralNetworkCANative.jni_getAnnTrainSpatialVariableNames(super.getHandle()));
            }
            this.g = true;
            return this.a;
        }
        return null;
    }

    private void a(double d, int n) {
        if (d <= 0.0 || d > 1.0) {
            String string = InternalResourceSpatialanalyst.loadString("dErrorRate", "ShouldBetweenZeroAndOne", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (n < 10) {
            String string = InternalResourceSpatialanalyst.loadString("nMaxTimes", "ArgumentInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
    }

    private void a(ANNParameter aNNParameter) {
        Object object;
        if (aNNParameter == null) {
            String string = InternalResourceSpatialanalyst.loadString("ArtificialNeuralNetworkParameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (aNNParameter.getLearningRate() <= 0.0 || aNNParameter.getLearningRate() > 1.0) {
            String string = InternalResourceSpatialanalyst.loadString("ArtificialNeuralNetworkParameter.getLearningRate()", "ShouldBetweenZeroAndOne", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!aNNParameter.isCustomNeighborhood()) {
            if (aNNParameter.getNeighborhoodNumber() <= 0) {
                String string = InternalResourceSpatialanalyst.loadString("ArtificialNeuralNetworkParameter.getLearningRate()", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        } else {
            object = aNNParameter.getCustomNeighborhoods();
            if (object == null || ((boolean[][])object).length == 0) {
                String string = InternalResourceSpatialanalyst.loadString("ArtificialNeuralNetworkParameter.getCustomNeighborhoods", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            for (int i = 0; i < ((boolean[][])object).length; ++i) {
                if (object[i] == null || object[i].length == 0) {
                    String string = InternalResourceSpatialanalyst.loadString("ANNCellularAutomataParameter.getCustomNeighborhoods[" + i + "]", "Global_ArgumentNull", "spatialanalyst_resources");
                    throw new NullPointerException(string);
                }
                if (object[i].length == ((boolean[][])object).length) continue;
                String string = InternalResourceSpatialanalyst.loadString("ANNCellularAutomataParameter.getCustomNeighborhoods[" + i + "] and ANNCellularAutomataParameter.getCustomNeighborhoods must have the same length.", "ArgumentInvalid", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
        }
        if (aNNParameter.getSampleCount() <= 0) {
            object = InternalResourceSpatialanalyst.loadString("ArtificialNeuralNetworkParameter.getSampleCount()", "GlobalGreaterThanHundred", "spatialanalyst_resources");
            throw new IllegalArgumentException((String)object);
        }
    }

    private void a(ANNCellularAutomataParameter aNNCellularAutomataParameter) {
        int n;
        if (aNNCellularAutomataParameter == null) {
            String string = InternalResourceSpatialanalyst.loadString("ANNCellularAutomataParameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        CellularAutomataParameter.CheckParameter(aNNCellularAutomataParameter.getCellularAutomataParameter());
        if (aNNCellularAutomataParameter.isCheckResult() && (null == aNNCellularAutomataParameter.getEndCellGrid() || 0L == InternalHandleSpatialanalyst.getHandle((InternalHandle)aNNCellularAutomataParameter.getEndCellGrid()))) {
            String string = InternalResourceSpatialanalyst.loadString("ANNCellularAutomataParameter.getEndCellGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (aNNCellularAutomataParameter.getThreshold() <= 0.0 || aNNCellularAutomataParameter.getThreshold() > 1.0) {
            String string = InternalResourceSpatialanalyst.loadString("ANNCellularAutomataParameter.getThreshold()", "ShouldBetweenZeroAndOne", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (aNNCellularAutomataParameter.getAlpha() <= 0 || aNNCellularAutomataParameter.getAlpha() > 10) {
            String string = InternalResourceSpatialanalyst.loadString("ANNCellularAutomataParameter.getAlpha()", "ArgumentInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean[][] blArray = aNNCellularAutomataParameter.getConversionRules();
        int[] nArray = aNNCellularAutomataParameter.getConversionClassIDs();
        if (blArray == null || blArray.length == 0) {
            String string = InternalResourceSpatialanalyst.loadString("ANNCellularAutomataParameter.getConversionRules()", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (nArray == null || nArray.length == 0) {
            String string = InternalResourceSpatialanalyst.loadString("ANNCellularAutomataParameter.getConversionClassIDs()", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (nArray == null || blArray.length == 0) {
            String string = InternalResourceSpatialanalyst.loadString("ANNCellularAutomataParameter.getConversionClassIDs and ANNCellularAutomataParameter.getConversionRules must have the same length.", "ArgumentInvalid", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        for (n = 0; n < blArray.length; ++n) {
            if (blArray[n] == null || blArray[n].length == 0) {
                String string = InternalResourceSpatialanalyst.loadString("ANNCellularAutomataParameter.getConversionRules[" + n + "]", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (blArray[n].length == blArray.length) continue;
            String string = InternalResourceSpatialanalyst.loadString("ANNCellularAutomataParameter.ConversionRules[" + n + "] and ANNCellularAutomataParameter.ConversionRules must have the same length.", "ArgumentInvalid", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        for (n = 0; n < nArray.length; ++n) {
            for (int i = n + 1; i < nArray.length; ++i) {
                if (nArray[n] != nArray[i]) continue;
                String string = InternalResourceSpatialanalyst.loadString("ANNCellularAutomataParameter.ConversionClassIDs[" + n + "] repeat.", "ArgumentInvalid", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void b() {
        int n = -1;
        Object object = b;
        synchronized (object) {
            n = b.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (c == null) {
            c = new Vector();
        }
        if (!c.contains(l)) {
            c.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (c != null && c.contains(l)) {
            c.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (c != null) {
            Vector vector = c;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "ANNCellularAutomata";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        SteppedHelper.fire((Collection)c, (SteppedEvent)steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    public static synchronized void addCAFlushedListener(CAFlushedListener l) {
        if (d == null) {
            d = new Vector();
        }
        if (!d.contains(l)) {
            d.add(l);
        }
    }

    public static synchronized void removeCAFlushedListener(CAFlushedListener l) {
        if (d != null && d.contains(l)) {
            d.remove(l);
        }
    }

    protected static void fireCAFlushed(CAFlushedEvent event) {
        if (d != null) {
            Vector vector = d;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((CAFlushedListener)vector.elementAt(i)).CAFlushed(event);
            }
        }
    }

    static void CAFlushedCallBack(String strFlushFilePathName) {
        Object object = new Object();
        CAFlushedEvent cAFlushedEvent = new CAFlushedEvent(object, strFlushFilePathName);
        ANNCellularAutomata.fireCAFlushed(cAFlushedEvent);
    }

    public synchronized void addAnnTrainedListener(AnnTrainedListener l) {
        if (this.e == null) {
            this.e = new Vector();
        }
        if (!this.e.contains(l)) {
            this.e.add(l);
        }
    }

    public synchronized void removeAnnTrainedListener(AnnTrainedListener l) {
        if (this.e != null && this.e.contains(l)) {
            this.e.remove(l);
        }
    }

    protected void fireAnnTrained(AnnTrainedEvent event) {
        if (this.e != null) {
            Vector vector = this.e;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((AnnTrainedListener)vector.elementAt(i)).annTrained(event);
            }
        }
    }

    static void annTrainedCallBack(ANNCellularAutomata annCellularAutomata, int iteration, double error) {
        if (annCellularAutomata != null) {
            AnnTrainedEvent annTrainedEvent = new AnnTrainedEvent((Object)annCellularAutomata, iteration, error);
            annCellularAutomata.fireAnnTrained(annTrainedEvent);
        }
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        b = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

