/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DelegateSimpleFeatureIterator;
import org.geotools.feature.collection.SubFeatureCollection;
import org.geotools.feature.collection.SubFeatureList;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.util.ProgressListener;

public abstract class AbstractFeatureCollection
implements SimpleFeatureCollection {
    protected String id;
    protected SimpleFeatureType schema;

    protected AbstractFeatureCollection(SimpleFeatureType memberType) {
        this.id = this.id == null ? "featureCollection" : this.id;
        this.schema = memberType;
    }

    public SimpleFeatureIterator features() {
        Iterator<SimpleFeature> iterator = this.openIterator();
        if (iterator instanceof SimpleFeatureIterator) {
            return (SimpleFeatureIterator)iterator;
        }
        DelegateSimpleFeatureIterator iter = new DelegateSimpleFeatureIterator((FeatureCollection<SimpleFeatureType, SimpleFeature>)this, iterator);
        return iter;
    }

    protected abstract Iterator<SimpleFeature> openIterator();

    public abstract int size();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object o) {
        Iterator<SimpleFeature> e = null;
        e = this.iterator();
        try {
            if (o == null) {
                while (e.hasNext()) {
                    if (e.next() != null) continue;
                    boolean bl = true;
                    return bl;
                }
            } else {
                while (e.hasNext()) {
                    if (!o.equals(e.next())) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (e instanceof FeatureIterator) {
                ((FeatureIterator)e).close();
            }
        }
    }

    public boolean containsAll(Collection<?> c) {
        Iterator<?> e = c.iterator();
        while (e.hasNext()) {
            if (this.contains(e.next())) continue;
            return false;
        }
        return true;
    }

    public final Iterator<SimpleFeature> iterator() {
        Iterator<SimpleFeature> iterator = this.openIterator();
        return iterator;
    }

    public boolean isEmpty() {
        Iterator<SimpleFeature> iterator = this.iterator();
        try {
            boolean bl = !iterator.hasNext();
            return bl;
        }
        finally {
            if (iterator instanceof FeatureIterator) {
                ((FeatureIterator)iterator).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        Iterator<SimpleFeature> e = null;
        try {
            e = this.iterator();
            int i = 0;
            while (e.hasNext()) {
                result[i] = e.next();
                ++i;
            }
            Object[] objectArray = result;
            return objectArray;
        }
        finally {
            if (e instanceof FeatureIterator) {
                ((FeatureIterator)e).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <O> O[] toArray(O[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        Iterator<SimpleFeature> it = this.iterator();
        try {
            O[] result = a;
            for (int i = 0; i < size; ++i) {
                result[i] = it.next();
            }
            if (a.length > size) {
                a[size] = null;
            }
            Object[] objectArray = a;
            return objectArray;
        }
        finally {
            if (it instanceof FeatureIterator) {
                ((FeatureIterator)it).close();
            }
        }
    }

    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        DataUtilities.visit(this, visitor, progress);
    }

    public SimpleFeatureCollection subCollection(Filter filter) {
        if (filter == Filter.INCLUDE) {
            return this;
        }
        return new SubFeatureCollection(this, filter);
    }

    public SimpleFeatureCollection sort(SortBy order) {
        return new SubFeatureList((SimpleFeatureCollection)this, order);
    }

    public String getID() {
        return this.id;
    }

    public SimpleFeatureType getSchema() {
        return this.schema;
    }

    public abstract ReferencedEnvelope getBounds();
}

