/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.util.List;
import org.geotools.geometry.jts.CurvedGeometry;
import org.geotools.geometry.jts.MultiCurvedGeometry;

public class MultiSurface
extends MultiPolygon
implements MultiCurvedGeometry<MultiPolygon> {
    private static final long serialVersionUID = -5796254063449438787L;
    double tolerance;

    public MultiSurface(List<Polygon> components, GeometryFactory factory, double tolerance) {
        super(components.toArray(new Polygon[components.size()]), factory);
        this.tolerance = tolerance;
    }

    public MultiSurface(Polygon[] polygons, GeometryFactory factory, double tolerance) {
        super(polygons, factory);
        this.tolerance = tolerance;
    }

    @Override
    public MultiPolygon linearize() {
        return this.linearize(this.tolerance);
    }

    @Override
    public MultiPolygon linearize(double tolerance) {
        int numGeometries = this.getNumGeometries();
        Polygon[] linearized = new Polygon[numGeometries];
        for (int k = 0; k < numGeometries; ++k) {
            Polygon component = (Polygon)this.getGeometryN(k);
            if (component instanceof CurvedGeometry) {
                CurvedGeometry curved = (CurvedGeometry)component;
                linearized[k] = (Polygon)curved.linearize(tolerance);
                continue;
            }
            linearized[k] = component;
        }
        return this.getFactory().createMultiPolygon(linearized);
    }

    @Override
    public String toCurvedText() {
        StringBuilder sb = new StringBuilder("MULTISURFACE ");
        int numGeometries = this.getNumGeometries();
        if (numGeometries == 0) {
            sb.append("EMPTY");
        } else {
            sb.append("(");
            for (int k = 0; k < numGeometries; ++k) {
                Polygon component = (Polygon)this.getGeometryN(k);
                if (component instanceof CurvedGeometry) {
                    CurvedGeometry curved = (CurvedGeometry)component;
                    sb.append(curved.toCurvedText());
                } else {
                    sb.append("(");
                    this.writeCoordinateSequence(sb, component.getExteriorRing().getCoordinateSequence());
                    int numHoles = component.getNumInteriorRing();
                    for (int i = 0; i < numHoles; ++i) {
                        sb.append(", ");
                        this.writeCoordinateSequence(sb, component.getInteriorRingN(i).getCoordinateSequence());
                    }
                    sb.append(")");
                }
                if (k >= numGeometries - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
        }
        return sb.toString();
    }

    private void writeCoordinateSequence(StringBuilder sb, CoordinateSequence cs) {
        sb.append("(");
        for (int i = 0; i < cs.size(); ++i) {
            sb.append(cs.getX(i) + " " + cs.getY(i));
            if (i >= cs.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
    }

    @Override
    public double getTolerance() {
        return this.tolerance;
    }

    @Override
    public int getCoordinatesDimension() {
        return 2;
    }
}

