/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.geotools.data.sort.SimpleFeatureIO;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.util.DefaultProgressListener;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.util.ProgressListener;

abstract class MarkFeatureIterator
implements FeatureIterator<Feature> {
    static final Logger LOGGER = Logging.getLogger(MarkFeatureIterator.class);

    MarkFeatureIterator() {
    }

    public static MarkFeatureIterator create(FeatureCollection fc, int maxFeaturesInMemory, ProgressListener listener) throws IOException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        int count = 0;
        if (listener == null) {
            listener = new DefaultProgressListener();
        }
        try (FeatureIterator fi = fc.features();){
            MemoryMarkFeatureIterator memoryMarkFeatureIterator;
            while (fi.hasNext()) {
                if (listener.isCanceled()) {
                    memoryMarkFeatureIterator = null;
                    return memoryMarkFeatureIterator;
                }
                Feature f = fi.next();
                features.add(f);
                if (++count < maxFeaturesInMemory) continue;
                if (fc.getSchema() instanceof SimpleFeatureType) {
                    DiskMarkFeatureIterator diskMarkFeatureIterator = new DiskMarkFeatureIterator(features, fi, (SimpleFeatureType)fc.getSchema(), listener);
                    return diskMarkFeatureIterator;
                }
                throw new IllegalArgumentException("Cannot offload to disk complex features and reached the max number of feature in memory: " + maxFeaturesInMemory);
            }
            memoryMarkFeatureIterator = new MemoryMarkFeatureIterator(features);
            return memoryMarkFeatureIterator;
        }
    }

    public abstract void mark() throws IOException;

    public abstract void reset() throws IOException;

    static class DiskMarkFeatureIterator
    extends MarkFeatureIterator {
        int mark;
        long markOffset;
        SimpleFeatureIO io;
        int curr;
        int featureCount;

        public DiskMarkFeatureIterator(List<Feature> features, FeatureIterator fi, SimpleFeatureType schema, ProgressListener listener) throws IOException {
            File file = File.createTempFile("z-ordered-", ".features");
            this.io = new SimpleFeatureIO(file, schema);
            for (Feature feature : features) {
                if (listener.isCanceled()) break;
                this.io.write((SimpleFeature)feature);
                ++this.featureCount;
            }
            while (fi.hasNext() && !listener.isCanceled()) {
                Feature feature = fi.next();
                this.io.write((SimpleFeature)feature);
                ++this.featureCount;
            }
            this.io.seek(0L);
        }

        public boolean hasNext() {
            return this.curr < this.featureCount;
        }

        public Feature next() throws NoSuchElementException {
            try {
                ++this.curr;
                return this.io.read();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void close() {
            if (this.io != null) {
                try {
                    this.io.close(true);
                    this.io = null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public void mark() throws IOException {
            this.mark = this.curr;
            this.markOffset = this.io.getOffset();
        }

        @Override
        public void reset() throws IOException {
            this.curr = this.mark;
            this.io.seek(this.markOffset);
        }

        public String toString() {
            return "DiskMarkFeatureIterator [mark=" + this.mark + ", markOffset=" + this.markOffset + ", io=" + this.io + ", curr=" + this.curr + ", featureCount=" + this.featureCount + "]";
        }

        protected void finalize() throws Throwable {
            if (this.io != null) {
                LOGGER.warning("There is code leaving DiskMarkFeatureIterator open, this is leaking temporary files!");
                this.close();
            }
        }
    }

    static class MemoryMarkFeatureIterator
    extends MarkFeatureIterator {
        List<Feature> features;
        int curr;
        int mark;

        public MemoryMarkFeatureIterator(List<Feature> features) {
            this.features = features;
            this.mark = 0;
            this.curr = 0;
        }

        public boolean hasNext() {
            return this.curr < this.features.size();
        }

        public Feature next() throws NoSuchElementException {
            return this.features.get(this.curr++);
        }

        public void close() {
        }

        @Override
        public void mark() throws IOException {
            this.mark = this.curr;
        }

        @Override
        public void reset() throws IOException {
            this.curr = this.mark;
        }

        public String toString() {
            return "MemoryMarkFeatureIterator [curr=" + this.curr + ", mark=" + this.mark + "]";
        }
    }
}

