/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.datasource.impl.base;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.datasource.dialect.DatabaseDialect;
import com.alibaba.nacos.plugin.datasource.impl.mysql.ConfigInfoMapperByMySql;
import com.alibaba.nacos.plugin.datasource.manager.DatabaseDialectManager;
import com.alibaba.nacos.plugin.datasource.model.MapperContext;
import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;

public class BaseConfigInfoMapper
extends ConfigInfoMapperByMySql {
    private DatabaseDialect databaseDialect = DatabaseDialectManager.getInstance().getDialect(this.getDataSource());

    public String getLimitPageSqlWithOffset(String sql, int startOffset, int pageSize) {
        return this.databaseDialect.getLimitPageSqlWithOffset(sql, startOffset, pageSize);
    }

    public String getLimitPageSqlWithMark(String sql) {
        return this.databaseDialect.getLimitPageSqlWithMark(sql);
    }

    public MapperResult findConfigInfoByAppFetchRows(MapperContext context) {
        int startRow = context.getStartRow();
        int pageSize = context.getPageSize();
        String appName = (String)context.getWhereParameter("app_name");
        String tenantId = (String)context.getWhereParameter("tenantId");
        String sql = this.getLimitPageSqlWithOffset("SELECT id,data_id,group_id,tenant_id,app_name,content FROM config_info WHERE tenant_id LIKE ? AND app_name= ?", startRow, pageSize);
        return new MapperResult(sql, CollectionUtils.list((Object[])new Object[]{tenantId, appName}));
    }

    public MapperResult getTenantIdList(MapperContext context) {
        int startRow = context.getStartRow();
        int pageSize = context.getPageSize();
        String sql = this.getLimitPageSqlWithOffset("SELECT tenant_id FROM config_info WHERE tenant_id != '' GROUP BY tenant_id ", startRow, pageSize);
        return new MapperResult(sql, Collections.emptyList());
    }

    public MapperResult getGroupIdList(MapperContext context) {
        int startRow = context.getStartRow();
        int pageSize = context.getPageSize();
        String sql = this.getLimitPageSqlWithOffset("SELECT group_id FROM config_info WHERE tenant_id ='' GROUP BY group_id ", startRow, pageSize);
        return new MapperResult(sql, Collections.emptyList());
    }

    public MapperResult findAllConfigKey(MapperContext context) {
        int startRow = context.getStartRow();
        int pageSize = context.getPageSize();
        String innerSql = this.getLimitPageSqlWithOffset(" SELECT id FROM config_info WHERE tenant_id LIKE ? ORDER BY id ", startRow, pageSize);
        String sql = " SELECT data_id,group_id,app_name  FROM ( " + innerSql + " g, config_info t WHERE g.id = t.id  ";
        return new MapperResult(sql, CollectionUtils.list((Object[])new Object[]{context.getWhereParameter("tenantId")}));
    }

    public MapperResult findAllConfigInfoBaseFetchRows(MapperContext context) {
        int startRow = context.getStartRow();
        int pageSize = context.getPageSize();
        String innerSql = this.getLimitPageSqlWithMark(" SELECT id FROM config_info ORDER BY id ");
        String sql = " SELECT t.id,data_id,group_id,content,md5 FROM ( " + innerSql + "  )  g, config_info t  WHERE g.id = t.id ";
        return new MapperResult(sql, CollectionUtils.list((Object[])new Object[]{startRow, pageSize}));
    }

    public MapperResult findAllConfigInfoFragment(MapperContext context) {
        int startRow = context.getStartRow();
        int pageSize = context.getPageSize();
        String sql = this.getLimitPageSqlWithOffset("SELECT id,data_id,group_id,tenant_id,app_name,content,md5,gmt_modified,type,encrypted_data_key FROM config_info WHERE id > ? ORDER BY id ASC ", startRow, pageSize);
        return new MapperResult(sql, CollectionUtils.list((Object[])new Object[]{context.getWhereParameter("id")}));
    }

    public MapperResult findChangeConfigFetchRows(MapperContext context) {
        String tenant = (String)context.getWhereParameter("tenantId");
        String dataId = (String)context.getWhereParameter("dataId");
        String group = (String)context.getWhereParameter("groupId");
        String appName = (String)context.getWhereParameter("app_name");
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        Timestamp startTime = (Timestamp)context.getWhereParameter("startTime");
        Timestamp endTime = (Timestamp)context.getWhereParameter("endTime");
        long lastMaxId = (Long)context.getWhereParameter("lastMaxId");
        int pageSize = context.getPageSize();
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sqlFetchRows = "SELECT id,data_id,group_id,tenant_id,app_name,content,type,md5,gmt_modified FROM config_info WHERE ";
        String where = " 1=1 ";
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            where = where + " AND data_id LIKE ? ";
            paramList.add(dataId);
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            where = where + " AND group_id LIKE ? ";
            paramList.add(group);
        }
        if (!StringUtils.isBlank((CharSequence)tenantTmp)) {
            where = where + " AND tenant_id = ? ";
            paramList.add(tenantTmp);
        }
        if (!StringUtils.isBlank((CharSequence)appName)) {
            where = where + " AND app_name = ? ";
            paramList.add(appName);
        }
        if (startTime != null) {
            where = where + " AND gmt_modified >=? ";
            paramList.add(startTime);
        }
        if (endTime != null) {
            where = where + " AND gmt_modified <=? ";
            paramList.add(endTime);
        }
        String originSql = "SELECT id,data_id,group_id,tenant_id,app_name,content,type,md5,gmt_modified FROM config_info WHERE " + where + " AND id > " + lastMaxId + " ORDER BY id ASC";
        String sql = this.getLimitPageSqlWithOffset(originSql, 0, pageSize);
        return new MapperResult(sql, paramList);
    }

    public MapperResult listGroupKeyMd5ByPageFetchRows(MapperContext context) {
        int startRow = context.getStartRow();
        int pageSize = context.getPageSize();
        String innerSql = this.getLimitPageSqlWithOffset(" SELECT id FROM config_info ORDER BY id ", startRow, pageSize);
        String sql = " SELECT t.id,data_id,group_id,tenant_id,app_name,md5,type,gmt_modified,encrypted_data_key FROM ( " + innerSql + " ) g, config_info t WHERE g.id = t.id";
        return new MapperResult(sql, Collections.emptyList());
    }

    public MapperResult findConfigInfoBaseLikeFetchRows(MapperContext context) {
        String dataId = (String)context.getWhereParameter("dataId");
        String group = (String)context.getWhereParameter("groupId");
        String content = (String)context.getWhereParameter("content");
        String sqlFetchRows = "SELECT id,data_id,group_id,tenant_id,content FROM config_info WHERE ";
        String where = " 1=1 AND tenant_id='' ";
        ArrayList<String> paramList = new ArrayList<String>();
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            where = where + " AND data_id LIKE ? ";
            paramList.add(dataId);
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            where = where + " AND group_id LIKE ";
            paramList.add(group);
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            where = where + " AND content LIKE ? ";
            paramList.add(content);
        }
        int startRow = context.getStartRow();
        int pageSize = context.getPageSize();
        String sql = this.getLimitPageSqlWithOffset("SELECT id,data_id,group_id,tenant_id,content FROM config_info WHERE " + where, startRow, pageSize);
        return new MapperResult(sql, paramList);
    }

    public MapperResult findConfigInfo4PageFetchRows(MapperContext context) {
        String tenant = (String)context.getWhereParameter("tenantId");
        String dataId = (String)context.getWhereParameter("dataId");
        String group = (String)context.getWhereParameter("groupId");
        String appName = (String)context.getWhereParameter("app_name");
        String content = (String)context.getWhereParameter("content");
        ArrayList<String> paramList = new ArrayList<String>();
        String sql = "SELECT id,data_id,group_id,tenant_id,app_name,content,type,encrypted_data_key FROM config_info";
        StringBuilder where = new StringBuilder(" WHERE ");
        where.append(" tenant_id=? ");
        paramList.add(tenant);
        if (StringUtils.isNotBlank((String)dataId)) {
            where.append(" AND data_id=? ");
            paramList.add(dataId);
        }
        if (StringUtils.isNotBlank((String)group)) {
            where.append(" AND group_id=? ");
            paramList.add(group);
        }
        if (StringUtils.isNotBlank((String)appName)) {
            where.append(" AND app_name=? ");
            paramList.add(appName);
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            where.append(" AND content LIKE ? ");
            paramList.add(content);
        }
        int startRow = context.getStartRow();
        int pageSize = context.getPageSize();
        String resultSql = this.getLimitPageSqlWithOffset("SELECT id,data_id,group_id,tenant_id,app_name,content,type,encrypted_data_key FROM config_info" + where, startRow, pageSize);
        return new MapperResult(resultSql, paramList);
    }

    public MapperResult findConfigInfoBaseByGroupFetchRows(MapperContext context) {
        int startRow = context.getStartRow();
        int pageSize = context.getPageSize();
        String sql = "SELECT id,data_id,group_id,content FROM config_info WHERE group_id=? AND tenant_id=? ";
        String resultSql = this.getLimitPageSqlWithOffset(sql, startRow, pageSize);
        return new MapperResult(resultSql, CollectionUtils.list((Object[])new Object[]{context.getWhereParameter("groupId"), context.getWhereParameter("tenantId")}));
    }

    public MapperResult findConfigInfoLike4PageFetchRows(MapperContext context) {
        String tenant = (String)context.getWhereParameter("tenantId");
        String dataId = (String)context.getWhereParameter("dataId");
        String group = (String)context.getWhereParameter("groupId");
        String appName = (String)context.getWhereParameter("app_name");
        String content = (String)context.getWhereParameter("content");
        String sqlFetchRows = "SELECT id,data_id,group_id,tenant_id,app_name,content,encrypted_data_key FROM config_info";
        StringBuilder where = new StringBuilder(" WHERE ");
        where.append(" tenant_id LIKE ? ");
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(tenant);
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            where.append(" AND data_id LIKE ? ");
            paramList.add(dataId);
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            where.append(" AND group_id LIKE ? ");
            paramList.add(group);
        }
        if (!StringUtils.isBlank((CharSequence)appName)) {
            where.append(" AND app_name = ? ");
            paramList.add(appName);
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            where.append(" AND content LIKE ? ");
            paramList.add(content);
        }
        int startRow = context.getStartRow();
        int pageSize = context.getPageSize();
        String sql = this.getLimitPageSqlWithOffset("SELECT id,data_id,group_id,tenant_id,app_name,content,encrypted_data_key FROM config_info" + where, startRow, pageSize);
        return new MapperResult(sql, paramList);
    }

    public MapperResult findAllConfigInfoFetchRows(MapperContext context) {
        String innerSql = this.getLimitPageSqlWithMark("SELECT id FROM config_info WHERE tenant_id LIKE ? ORDER BY id ");
        String sql = " SELECT t.id,data_id,group_id,tenant_id,app_name,content,md5  FROM ( " + innerSql + " ) g, config_info t  WHERE g.id = t.id ";
        return new MapperResult(sql, CollectionUtils.list((Object[])new Object[]{context.getWhereParameter("tenantId"), context.getStartRow(), context.getPageSize()}));
    }

    public String getTableName() {
        return "config_info";
    }
}

